/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.Locator;
import com.microsoft.playwright.impl.PlaywrightImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.SharedSelectors;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.options.AriaRole;
import java.util.regex.Pattern;

public class LocatorUtils {
    static String getByTextSelector(Object text, Locator.GetByTextOptions options) {
        boolean exact = options != null && options.exact != null && options.exact != false;
        return "internal:text=" + LocatorUtils.escapeForTextSelector(text, exact);
    }

    static String getByLabelSelector(Object text, Locator.GetByLabelOptions options) {
        boolean exact = options != null && options.exact != null && options.exact != false;
        return "internal:label=" + LocatorUtils.escapeForTextSelector(text, exact);
    }

    private static String getByAttributeTextSelector(String attrName, Object value, boolean exact) {
        return "internal:attr=[" + attrName + "=" + LocatorUtils.escapeForAttributeSelector(value, exact) + "]";
    }

    static String getByTestIdSelector(Object testId, PlaywrightImpl playwright) {
        String testIdAttributeName = ((SharedSelectors)playwright.selectors()).testIdAttributeName;
        return LocatorUtils.getByAttributeTextSelector(testIdAttributeName, testId, true);
    }

    static String getByAltTextSelector(Object text, Locator.GetByAltTextOptions options) {
        boolean exact = options != null && options.exact != null && options.exact != false;
        return LocatorUtils.getByAttributeTextSelector("alt", text, exact);
    }

    static String getByTitleSelector(Object text, Locator.GetByTitleOptions options) {
        boolean exact = options != null && options.exact != null && options.exact != false;
        return LocatorUtils.getByAttributeTextSelector("title", text, exact);
    }

    static String getByPlaceholderSelector(Object text, Locator.GetByPlaceholderOptions options) {
        boolean exact = options != null && options.exact != null && options.exact != false;
        return LocatorUtils.getByAttributeTextSelector("placeholder", text, exact);
    }

    private static void addAttr(StringBuilder result, String name, String value) {
        result.append("[").append(name).append("=").append(value).append("]");
    }

    static String getByRoleSelector(AriaRole role, Locator.GetByRoleOptions options) {
        StringBuilder result = new StringBuilder();
        result.append("internal:role=").append(role.name().toLowerCase());
        if (options != null) {
            if (options.checked != null) {
                LocatorUtils.addAttr(result, "checked", options.checked.toString());
            }
            if (options.disabled != null) {
                LocatorUtils.addAttr(result, "disabled", options.disabled.toString());
            }
            if (options.selected != null) {
                LocatorUtils.addAttr(result, "selected", options.selected.toString());
            }
            if (options.expanded != null) {
                LocatorUtils.addAttr(result, "expanded", options.expanded.toString());
            }
            if (options.includeHidden != null) {
                LocatorUtils.addAttr(result, "include-hidden", options.includeHidden.toString());
            }
            if (options.level != null) {
                LocatorUtils.addAttr(result, "level", options.level.toString());
            }
            if (options.name != null) {
                String name = LocatorUtils.escapeForAttributeSelector(options.name, options.exact != null && options.exact != false);
                LocatorUtils.addAttr(result, "name", name);
            }
            if (options.pressed != null) {
                LocatorUtils.addAttr(result, "pressed", options.pressed.toString());
            }
        }
        return result.toString();
    }

    private static String escapeRegexForSelector(Pattern re) {
        return LocatorUtils.toJsRegExp(re).replaceAll("(^|[^\\\\])(\\\\\\\\)*([\"'`])", "$1$2\\\\$3").replaceAll(">>", "\\\\>\\\\>");
    }

    static String escapeForTextSelector(Object value, boolean exact) {
        if (value instanceof Pattern) {
            return LocatorUtils.escapeRegexForSelector((Pattern)value);
        }
        if (value instanceof String) {
            return Serialization.gson().toJson(value) + (exact ? "s" : "i");
        }
        throw new IllegalArgumentException("text parameter must be Pattern or String: " + value);
    }

    private static String escapeForAttributeSelector(Object value, boolean exact) {
        if (value instanceof Pattern) {
            return LocatorUtils.escapeRegexForSelector((Pattern)value);
        }
        if (value instanceof String) {
            return '\"' + ((String)value).replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"") + '\"' + (exact ? "" : "i");
        }
        throw new IllegalArgumentException("Attribute can be String or Pattern, found: " + value);
    }

    private static String toJsRegExp(Pattern pattern) {
        return "/" + pattern.pattern() + "/" + Utils.toJsRegexFlags(pattern);
    }
}

