/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonObject;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.WebSocket;
import com.microsoft.playwright.WebSocketFrame;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.ListenerCollection;
import com.microsoft.playwright.impl.PageImpl;
import com.microsoft.playwright.impl.WaitableEvent;
import com.microsoft.playwright.impl.WaitableRace;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.function.Consumer;
import java.util.function.Predicate;

class WebSocketImpl
extends ChannelOwner
implements WebSocket {
    private final ListenerCollection<EventType> listeners = new ListenerCollection();
    private final PageImpl page;
    private boolean isClosed;

    WebSocketImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
        this.page = (PageImpl)parent;
    }

    @Override
    public void onClose(Consumer<WebSocket> handler) {
        this.listeners.add(EventType.CLOSE, handler);
    }

    @Override
    public void offClose(Consumer<WebSocket> handler) {
        this.listeners.remove(EventType.CLOSE, handler);
    }

    @Override
    public void onFrameReceived(Consumer<WebSocketFrame> handler) {
        this.listeners.add(EventType.FRAMERECEIVED, handler);
    }

    @Override
    public void offFrameReceived(Consumer<WebSocketFrame> handler) {
        this.listeners.remove(EventType.FRAMERECEIVED, handler);
    }

    @Override
    public void onFrameSent(Consumer<WebSocketFrame> handler) {
        this.listeners.add(EventType.FRAMESENT, handler);
    }

    @Override
    public void offFrameSent(Consumer<WebSocketFrame> handler) {
        this.listeners.remove(EventType.FRAMESENT, handler);
    }

    @Override
    public void onSocketError(Consumer<String> handler) {
        this.listeners.add(EventType.SOCKETERROR, handler);
    }

    @Override
    public void offSocketError(Consumer<String> handler) {
        this.listeners.remove(EventType.SOCKETERROR, handler);
    }

    @Override
    public WebSocketFrame waitForFrameReceived(WebSocket.WaitForFrameReceivedOptions options, Runnable code) {
        return this.withWaitLogging("WebSocket.waitForFrameReceived", logger -> this.waitForFrameReceivedImpl(options, code));
    }

    private WebSocketFrame waitForFrameReceivedImpl(WebSocket.WaitForFrameReceivedOptions options, Runnable code) {
        if (options == null) {
            options = new WebSocket.WaitForFrameReceivedOptions();
        }
        return this.waitForEventWithTimeout(EventType.FRAMERECEIVED, code, options.predicate, options.timeout);
    }

    @Override
    public WebSocketFrame waitForFrameSent(WebSocket.WaitForFrameSentOptions options, Runnable code) {
        return this.withWaitLogging("WebSocket.waitForFrameSent", logger -> this.waitForFrameSentImpl(options, code));
    }

    private WebSocketFrame waitForFrameSentImpl(WebSocket.WaitForFrameSentOptions options, Runnable code) {
        if (options == null) {
            options = new WebSocket.WaitForFrameSentOptions();
        }
        return this.waitForEventWithTimeout(EventType.FRAMESENT, code, options.predicate, options.timeout);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public String url() {
        return this.initializer.get("url").getAsString();
    }

    private WebSocketFrame waitForEventWithTimeout(EventType eventType, Runnable code, Predicate<WebSocketFrame> predicate, Double timeout) {
        ArrayList waitables = new ArrayList();
        waitables.add(new WaitableEvent<EventType, WebSocketFrame>(this.listeners, eventType, predicate));
        waitables.add(new WaitableWebSocketClose());
        waitables.add(new WaitableWebSocketError());
        waitables.add(this.page.createWaitForCloseHelper());
        waitables.add(this.page.createWaitableTimeout(timeout));
        return (WebSocketFrame)this.runUntil(code, new WaitableRace(waitables));
    }

    @Override
    void handleEvent(String event, JsonObject parameters) {
        switch (event) {
            case "frameSent": {
                int opCode = parameters.get("opcode").getAsInt();
                if (opCode != 1 && opCode != 2) break;
                WebSocketFrameImpl WebSocketFrame2 = new WebSocketFrameImpl(parameters.get("data").getAsString(), opCode == 2);
                this.listeners.notify(EventType.FRAMESENT, WebSocketFrame2);
                break;
            }
            case "frameReceived": {
                int opCode = parameters.get("opcode").getAsInt();
                if (opCode != 1 && opCode != 2) break;
                WebSocketFrameImpl WebSocketFrame3 = new WebSocketFrameImpl(parameters.get("data").getAsString(), opCode == 2);
                this.listeners.notify(EventType.FRAMERECEIVED, WebSocketFrame3);
                break;
            }
            case "socketError": {
                String error = parameters.get("error").getAsString();
                this.listeners.notify(EventType.SOCKETERROR, error);
                break;
            }
            case "close": {
                this.isClosed = true;
                this.listeners.notify(EventType.CLOSE, this);
                break;
            }
            default: {
                throw new PlaywrightException("Unknown event: " + event);
            }
        }
    }

    private static class WebSocketFrameImpl
    implements WebSocketFrame {
        private final byte[] bytes;

        WebSocketFrameImpl(String payload, boolean isBase64) {
            this.bytes = isBase64 ? Base64.getDecoder().decode(payload) : payload.getBytes();
        }

        @Override
        public byte[] binary() {
            return this.bytes;
        }

        @Override
        public String text() {
            return new String(this.bytes, StandardCharsets.UTF_8);
        }
    }

    private class WaitableWebSocketError<T>
    extends WaitableEvent<EventType, T> {
        WaitableWebSocketError() {
            super(WebSocketImpl.this.listeners, EventType.SOCKETERROR);
        }

        @Override
        public T get() {
            throw new PlaywrightException("Socket error");
        }
    }

    private class WaitableWebSocketClose<T>
    extends WaitableEvent<EventType, T> {
        WaitableWebSocketClose() {
            super(WebSocketImpl.this.listeners, EventType.CLOSE);
        }

        @Override
        public T get() {
            throw new PlaywrightException("Socket closed");
        }
    }

    static enum EventType {
        CLOSE,
        FRAMERECEIVED,
        FRAMESENT,
        SOCKETERROR;

    }
}

