/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.CDPSession;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.ArtifactImpl;
import com.microsoft.playwright.impl.BrowserContextImpl;
import com.microsoft.playwright.impl.BrowserTypeImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.ListenerCollection;
import com.microsoft.playwright.impl.PageImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.options.HarContentPolicy;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

class BrowserImpl
extends ChannelOwner
implements Browser {
    final Set<BrowserContextImpl> contexts = new HashSet<BrowserContextImpl>();
    private final ListenerCollection<EventType> listeners = new ListenerCollection();
    boolean isConnectedOverWebSocket;
    private boolean isConnected = true;
    BrowserTypeImpl browserType;
    BrowserType.LaunchOptions launchOptions;
    private Path tracePath;
    String closeReason;

    BrowserImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
    }

    @Override
    public void onDisconnected(Consumer<Browser> handler) {
        this.listeners.add(EventType.DISCONNECTED, handler);
    }

    @Override
    public void offDisconnected(Consumer<Browser> handler) {
        this.listeners.remove(EventType.DISCONNECTED, handler);
    }

    @Override
    public BrowserType browserType() {
        return this.browserType;
    }

    @Override
    public void close(Browser.CloseOptions options) {
        this.withLogging("Browser.close", () -> this.closeImpl(options));
    }

    private void closeImpl(Browser.CloseOptions options) {
        block6: {
            if (options == null) {
                options = new Browser.CloseOptions();
            }
            this.closeReason = options.reason;
            if (this.isConnectedOverWebSocket) {
                try {
                    this.connection.close();
                }
                catch (IOException e) {
                    throw new PlaywrightException("Failed to close browser connection", e);
                }
                return;
            }
            try {
                this.sendMessage("close");
            }
            catch (PlaywrightException e) {
                if (Utils.isSafeCloseError(e)) break block6;
                throw e;
            }
        }
    }

    void notifyRemoteClosed() {
        for (BrowserContextImpl context : new ArrayList<BrowserContextImpl>(this.contexts)) {
            for (PageImpl page : new ArrayList<PageImpl>(context.pages)) {
                page.didClose();
            }
            context.didClose();
        }
        this.didClose();
    }

    @Override
    public List<BrowserContext> contexts() {
        return new ArrayList<BrowserContext>(this.contexts);
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public BrowserContextImpl newContext(Browser.NewContextOptions options) {
        return this.withLogging("Browser.newContext", () -> this.newContextImpl(options));
    }

    private BrowserContextImpl newContextImpl(Browser.NewContextOptions options) {
        options = options == null ? new Browser.NewContextOptions() : Utils.convertType(options, Browser.NewContextOptions.class);
        if (options.storageStatePath != null) {
            try {
                byte[] bytes = Files.readAllBytes(options.storageStatePath);
                options.storageState = new String(bytes, StandardCharsets.UTF_8);
                options.storageStatePath = null;
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to read storage state from file", e);
            }
        }
        JsonObject storageState = null;
        if (options.storageState != null) {
            storageState = (JsonObject)new Gson().fromJson(options.storageState, JsonObject.class);
            options.storageState = null;
        }
        JsonObject recordHar = null;
        Path recordHarPath = options.recordHarPath;
        HarContentPolicy harContentPolicy = null;
        if (options.recordHarPath != null) {
            recordHar = new JsonObject();
            recordHar.addProperty("path", options.recordHarPath.toString());
            if (options.recordHarContent != null) {
                harContentPolicy = options.recordHarContent;
            } else if (options.recordHarOmitContent != null && options.recordHarOmitContent.booleanValue()) {
                harContentPolicy = HarContentPolicy.OMIT;
            }
            if (harContentPolicy != null) {
                recordHar.addProperty("content", harContentPolicy.name().toLowerCase());
            }
            if (options.recordHarMode != null) {
                recordHar.addProperty("mode", options.recordHarMode.name().toLowerCase());
            }
            Serialization.addHarUrlFilter(recordHar, options.recordHarUrlFilter);
            options.recordHarPath = null;
            options.recordHarMode = null;
            options.recordHarOmitContent = null;
            options.recordHarContent = null;
            options.recordHarUrlFilter = null;
        } else {
            if (options.recordHarOmitContent != null) {
                throw new PlaywrightException("recordHarOmitContent is set but recordHarPath is null");
            }
            if (options.recordHarUrlFilter != null) {
                throw new PlaywrightException("recordHarUrlFilter is set but recordHarPath is null");
            }
            if (options.recordHarMode != null) {
                throw new PlaywrightException("recordHarMode is set but recordHarPath is null");
            }
            if (options.recordHarContent != null) {
                throw new PlaywrightException("recordHarContent is set but recordHarPath is null");
            }
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        if (storageState != null) {
            params.add("storageState", (JsonElement)storageState);
        }
        if (recordHar != null) {
            params.add("recordHar", (JsonElement)recordHar);
        }
        if (options.recordVideoDir != null) {
            JsonObject recordVideo = new JsonObject();
            recordVideo.addProperty("dir", options.recordVideoDir.toAbsolutePath().toString());
            if (options.recordVideoSize != null) {
                recordVideo.add("size", Serialization.gson().toJsonTree((Object)options.recordVideoSize));
            }
            params.remove("recordVideoDir");
            params.remove("recordVideoSize");
            params.add("recordVideo", (JsonElement)recordVideo);
        } else if (options.recordVideoSize != null) {
            throw new PlaywrightException("recordVideoSize is set but recordVideoDir is null");
        }
        if (options.viewportSize != null) {
            if (options.viewportSize.isPresent()) {
                JsonElement size = params.get("viewportSize");
                params.remove("viewportSize");
                params.add("viewport", size);
            } else {
                params.remove("viewportSize");
                params.addProperty("noDefaultViewport", Boolean.valueOf(true));
            }
        }
        Utils.addToProtocol(params, options.clientCertificates);
        params.remove("acceptDownloads");
        if (options.acceptDownloads != null) {
            params.addProperty("acceptDownloads", options.acceptDownloads != false ? "accept" : "deny");
        }
        JsonElement result = this.sendMessage("newContext", params);
        BrowserContextImpl context = (BrowserContextImpl)this.connection.getExistingObject(result.getAsJsonObject().getAsJsonObject("context").get("guid").getAsString());
        context.videosDir = options.recordVideoDir;
        if (options.baseURL != null) {
            context.setBaseUrl(options.baseURL);
        }
        context.setRecordHar(recordHarPath, harContentPolicy);
        if (this.launchOptions != null) {
            context.tracing().setTracesDir(this.launchOptions.tracesDir);
        }
        this.contexts.add(context);
        return context;
    }

    @Override
    public Page newPage(Browser.NewPageOptions options) {
        return this.withLogging("Browser.newPage", () -> this.newPageImpl(options));
    }

    @Override
    public void startTracing(Page page, Browser.StartTracingOptions options) {
        this.withLogging("Browser.startTracing", () -> this.startTracingImpl(page, options));
    }

    private void startTracingImpl(Page page, Browser.StartTracingOptions options) {
        if (options == null) {
            options = new Browser.StartTracingOptions();
        }
        this.tracePath = options.path;
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        if (page != null) {
            params.add("page", (JsonElement)((PageImpl)page).toProtocolRef());
        }
        this.sendMessage("startTracing", params);
    }

    @Override
    public byte[] stopTracing() {
        return this.withLogging("Browser.stopTracing", () -> this.stopTracingImpl());
    }

    private byte[] stopTracingImpl() {
        JsonObject json = this.sendMessage("stopTracing").getAsJsonObject();
        ArtifactImpl artifact = (ArtifactImpl)this.connection.getExistingObject(json.getAsJsonObject().getAsJsonObject("artifact").get("guid").getAsString());
        byte[] data = artifact.readAllBytes();
        artifact.delete();
        if (this.tracePath != null) {
            try {
                Files.createDirectories(this.tracePath.getParent(), new FileAttribute[0]);
                Files.write(this.tracePath, data, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to write trace file", e);
            }
            finally {
                this.tracePath = null;
            }
        }
        return data;
    }

    private Page newPageImpl(Browser.NewPageOptions options) {
        BrowserContextImpl context = this.newContext(Utils.convertType(options, Browser.NewContextOptions.class));
        PageImpl page = context.newPage();
        page.ownedContext = context;
        context.ownerPage = page;
        return page;
    }

    private String name() {
        return this.initializer.get("name").getAsString();
    }

    boolean isChromium() {
        return "chromium".equals(this.name());
    }

    @Override
    public String version() {
        return this.initializer.get("version").getAsString();
    }

    @Override
    void handleEvent(String event, JsonObject parameters) {
        if ("close".equals(event)) {
            this.didClose();
        }
    }

    @Override
    public CDPSession newBrowserCDPSession() {
        JsonObject params = new JsonObject();
        JsonObject result = this.sendMessage("newBrowserCDPSession", params).getAsJsonObject();
        return (CDPSession)this.connection.getExistingObject(result.getAsJsonObject("session").get("guid").getAsString());
    }

    private void didClose() {
        this.isConnected = false;
        this.listeners.notify(EventType.DISCONNECTED, this);
    }

    static enum EventType {
        DISCONNECTED;

    }
}

