/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.BrowserContextImpl;
import com.microsoft.playwright.impl.BrowserImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Connection;
import com.microsoft.playwright.impl.JsonPipe;
import com.microsoft.playwright.impl.PlaywrightImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Transport;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.options.HarContentPolicy;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Consumer;

class BrowserTypeImpl
extends ChannelOwner
implements BrowserType {
    BrowserTypeImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
    }

    @Override
    public BrowserImpl launch(BrowserType.LaunchOptions options) {
        return this.withLogging("BrowserType.launch", () -> this.launchImpl(options));
    }

    private BrowserImpl launchImpl(BrowserType.LaunchOptions options) {
        if (options == null) {
            options = new BrowserType.LaunchOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        JsonElement result = this.sendMessage("launch", params);
        BrowserImpl browser = (BrowserImpl)this.connection.getExistingObject(result.getAsJsonObject().getAsJsonObject("browser").get("guid").getAsString());
        browser.browserType = this;
        browser.launchOptions = options;
        return browser;
    }

    @Override
    public Browser connect(String wsEndpoint, BrowserType.ConnectOptions options) {
        return this.withLogging("BrowserType.connect", () -> this.connectImpl(wsEndpoint, options));
    }

    private Browser connectImpl(String wsEndpoint, BrowserType.ConnectOptions options) {
        if (options == null) {
            options = new BrowserType.ConnectOptions();
        }
        JsonObject params = new Gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("wsEndpoint", wsEndpoint);
        if (!params.has("headers")) {
            params.add("headers", (JsonElement)new JsonObject());
        }
        JsonObject headers = params.get("headers").getAsJsonObject();
        boolean foundBrowserHeader = false;
        for (String name : headers.keySet()) {
            if (!"x-playwright-browser".equalsIgnoreCase(name)) continue;
            foundBrowserHeader = true;
            break;
        }
        if (!foundBrowserHeader) {
            headers.addProperty("x-playwright-browser", this.name());
        }
        JsonObject json = this.connection.localUtils().sendMessage("connect", params).getAsJsonObject();
        JsonPipe pipe = (JsonPipe)this.connection.getExistingObject(json.getAsJsonObject("pipe").get("guid").getAsString());
        Connection connection = new Connection((Transport)pipe, this.connection.env, this.connection.localUtils);
        PlaywrightImpl playwright = connection.initializePlaywright();
        if (!playwright.initializer.has("preLaunchedBrowser")) {
            try {
                connection.close();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
            throw new PlaywrightException("Malformed endpoint. Did you use launchServer method?");
        }
        playwright.initSharedSelectors((PlaywrightImpl)this.connection.getExistingObject("Playwright"));
        BrowserImpl browser = (BrowserImpl)connection.getExistingObject(playwright.initializer.getAsJsonObject("preLaunchedBrowser").get("guid").getAsString());
        browser.isConnectedOverWebSocket = true;
        browser.browserType = this;
        Consumer<JsonPipe> connectionCloseListener = t -> browser.notifyRemoteClosed();
        pipe.onClose(connectionCloseListener);
        browser.onDisconnected(b -> {
            playwright.unregisterSelectors();
            pipe.offClose(connectionCloseListener);
            try {
                connection.close();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        });
        return browser;
    }

    @Override
    public Browser connectOverCDP(String endpointURL, BrowserType.ConnectOverCDPOptions options) {
        if (!"chromium".equals(this.name())) {
            throw new PlaywrightException("Connecting over CDP is only supported in Chromium.");
        }
        return this.withLogging("BrowserType.connectOverCDP", () -> this.connectOverCDPImpl(endpointURL, options));
    }

    private Browser connectOverCDPImpl(String endpointURL, BrowserType.ConnectOverCDPOptions options) {
        if (options == null) {
            options = new BrowserType.ConnectOverCDPOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("endpointURL", endpointURL);
        JsonObject json = this.sendMessage("connectOverCDP", params).getAsJsonObject();
        BrowserImpl browser = (BrowserImpl)this.connection.getExistingObject(json.getAsJsonObject("browser").get("guid").getAsString());
        browser.browserType = this;
        if (json.has("defaultContext")) {
            String contextId = json.getAsJsonObject("defaultContext").get("guid").getAsString();
            BrowserContextImpl defaultContext = (BrowserContextImpl)this.connection.getExistingObject(contextId);
            browser.contexts.add(defaultContext);
        }
        return browser;
    }

    @Override
    public String executablePath() {
        return this.initializer.get("executablePath").getAsString();
    }

    @Override
    public BrowserContextImpl launchPersistentContext(Path userDataDir, BrowserType.LaunchPersistentContextOptions options) {
        return this.withLogging("BrowserType.launchPersistentContext", () -> this.launchPersistentContextImpl(userDataDir, options));
    }

    private BrowserContextImpl launchPersistentContextImpl(Path userDataDir, BrowserType.LaunchPersistentContextOptions options) {
        options = options == null ? new BrowserType.LaunchPersistentContextOptions() : Utils.convertType(options, BrowserType.LaunchPersistentContextOptions.class);
        JsonObject recordHar = null;
        Path recordHarPath = options.recordHarPath;
        HarContentPolicy harContentPolicy = null;
        if (options.recordHarPath != null) {
            recordHar = new JsonObject();
            recordHar.addProperty("path", options.recordHarPath.toString());
            if (options.recordHarContent != null) {
                harContentPolicy = options.recordHarContent;
            } else if (options.recordHarOmitContent != null && options.recordHarOmitContent.booleanValue()) {
                harContentPolicy = HarContentPolicy.OMIT;
            }
            if (harContentPolicy != null) {
                recordHar.addProperty("content", harContentPolicy.name().toLowerCase());
            }
            if (options.recordHarMode != null) {
                recordHar.addProperty("mode", options.recordHarMode.toString().toLowerCase());
            }
            Serialization.addHarUrlFilter(recordHar, options.recordHarUrlFilter);
            options.recordHarPath = null;
            options.recordHarMode = null;
            options.recordHarOmitContent = null;
            options.recordHarContent = null;
            options.recordHarUrlFilter = null;
        } else {
            if (options.recordHarOmitContent != null) {
                throw new PlaywrightException("recordHarOmitContent is set but recordHarPath is null");
            }
            if (options.recordHarUrlFilter != null) {
                throw new PlaywrightException("recordHarUrlFilter is set but recordHarPath is null");
            }
            if (options.recordHarMode != null) {
                throw new PlaywrightException("recordHarMode is set but recordHarPath is null");
            }
            if (options.recordHarContent != null) {
                throw new PlaywrightException("recordHarContent is set but recordHarPath is null");
            }
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("userDataDir", userDataDir.toString());
        if (recordHar != null) {
            params.add("recordHar", (JsonElement)recordHar);
        }
        if (options.recordVideoDir != null) {
            JsonObject recordVideo = new JsonObject();
            recordVideo.addProperty("dir", options.recordVideoDir.toAbsolutePath().toString());
            if (options.recordVideoSize != null) {
                recordVideo.add("size", Serialization.gson().toJsonTree((Object)options.recordVideoSize));
            }
            params.remove("recordVideoDir");
            params.remove("recordVideoSize");
            params.add("recordVideo", (JsonElement)recordVideo);
        } else if (options.recordVideoSize != null) {
            throw new PlaywrightException("recordVideoSize is set but recordVideoDir is null");
        }
        if (options.viewportSize != null) {
            if (options.viewportSize.isPresent()) {
                JsonElement size = params.get("viewportSize");
                params.remove("viewportSize");
                params.add("viewport", size);
            } else {
                params.remove("viewportSize");
                params.addProperty("noDefaultViewport", Boolean.valueOf(true));
            }
        }
        Utils.addToProtocol(params, options.clientCertificates);
        params.remove("acceptDownloads");
        if (options.acceptDownloads != null) {
            params.addProperty("acceptDownloads", options.acceptDownloads != false ? "accept" : "deny");
        }
        JsonObject json = this.sendMessage("launchPersistentContext", params).getAsJsonObject();
        BrowserContextImpl context = (BrowserContextImpl)this.connection.getExistingObject(json.getAsJsonObject("context").get("guid").getAsString());
        context.videosDir = options.recordVideoDir;
        if (options.baseURL != null) {
            context.setBaseUrl(options.baseURL);
        }
        context.setRecordHar(recordHarPath, harContentPolicy);
        context.tracing().setTracesDir(options.tracesDir);
        return context;
    }

    @Override
    public String name() {
        return this.initializer.get("name").getAsString();
    }
}

