/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonObject;
import com.microsoft.playwright.Clock;
import com.microsoft.playwright.impl.BrowserContextImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import java.util.Date;

class ClockImpl
implements Clock {
    private final ChannelOwner browserContext;

    ClockImpl(BrowserContextImpl browserContext) {
        this.browserContext = browserContext;
    }

    @Override
    public void fastForward(long ticks) {
        JsonObject params = new JsonObject();
        params.addProperty("ticksNumber", (Number)ticks);
        this.browserContext.sendMessage("clockFastForward", params);
    }

    @Override
    public void fastForward(String ticks) {
        JsonObject params = new JsonObject();
        params.addProperty("ticksString", ticks);
        this.browserContext.sendMessage("clockFastForward", params);
    }

    @Override
    public void install(Clock.InstallOptions options) {
        JsonObject params = new JsonObject();
        if (options != null) {
            ClockImpl.parseTime(options.time, params);
        }
        this.browserContext.sendMessage("clockInstall", params);
    }

    @Override
    public void runFor(long ticks) {
        JsonObject params = new JsonObject();
        params.addProperty("ticksNumber", (Number)ticks);
        this.browserContext.sendMessage("clockRunFor", params);
    }

    @Override
    public void runFor(String ticks) {
        JsonObject params = new JsonObject();
        params.addProperty("ticksString", ticks);
        this.browserContext.sendMessage("clockRunFor", params);
    }

    @Override
    public void pauseAt(long time) {
        JsonObject params = new JsonObject();
        params.addProperty("timeNumber", (Number)time);
        this.browserContext.sendMessage("clockPauseAt", params);
    }

    @Override
    public void pauseAt(String time) {
        JsonObject params = new JsonObject();
        params.addProperty("timeString", time);
        this.browserContext.sendMessage("clockPauseAt", params);
    }

    @Override
    public void pauseAt(Date time) {
        JsonObject params = new JsonObject();
        params.addProperty("timeNumber", (Number)time.getTime());
        this.browserContext.sendMessage("clockPauseAt", params);
    }

    @Override
    public void resume() {
        this.browserContext.sendMessage("clockResume");
    }

    @Override
    public void setFixedTime(long time) {
        JsonObject params = new JsonObject();
        params.addProperty("timeNumber", (Number)time);
        this.browserContext.sendMessage("clockSetFixedTime", params);
    }

    @Override
    public void setFixedTime(String time) {
        JsonObject params = new JsonObject();
        params.addProperty("timeString", time);
        this.browserContext.sendMessage("clockSetFixedTime", params);
    }

    @Override
    public void setFixedTime(Date time) {
        JsonObject params = new JsonObject();
        params.addProperty("timeNumber", (Number)time.getTime());
        this.browserContext.sendMessage("clockSetFixedTime", params);
    }

    @Override
    public void setSystemTime(long time) {
        JsonObject params = new JsonObject();
        params.addProperty("timeNumber", (Number)time);
        this.browserContext.sendMessage("clockSetSystemTime", params);
    }

    @Override
    public void setSystemTime(String time) {
        JsonObject params = new JsonObject();
        params.addProperty("timeString", time);
        this.browserContext.sendMessage("clockSetSystemTime", params);
    }

    @Override
    public void setSystemTime(Date time) {
        JsonObject params = new JsonObject();
        params.addProperty("timeNumber", (Number)time.getTime());
        this.browserContext.sendMessage("clockSetSystemTime", params);
    }

    private static void parseTime(Object time, JsonObject params) {
        if (time instanceof Long) {
            params.addProperty("timeNumber", (Number)((Long)time));
        } else if (time instanceof Date) {
            params.addProperty("timeNumber", (Number)((Date)time).getTime());
        } else if (time instanceof String) {
            params.addProperty("timeString", (String)time);
        }
    }
}

