/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.APIResponse;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.Route;
import com.microsoft.playwright.impl.APIRequestContextImpl;
import com.microsoft.playwright.impl.APIResponseImpl;
import com.microsoft.playwright.impl.BrowserContextImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.RequestImpl;
import com.microsoft.playwright.impl.RequestOptionsImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.options.RequestOptions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;

public class RouteImpl
extends ChannelOwner
implements Route {
    private final RequestImpl request;
    private boolean handled;
    BrowserContextImpl browserContext;
    boolean fallbackCalled;
    boolean shouldResumeIfFallbackIsCalled;

    public RouteImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
        this.request = (RequestImpl)this.connection.getExistingObject(initializer.getAsJsonObject("request").get("guid").getAsString());
    }

    @Override
    public void abort(String errorCode) {
        this.startHandling();
        this.withLogging("Route.abort", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("errorCode", errorCode);
            params.addProperty("requestUrl", this.request.initializer.get("url").getAsString());
            this.sendMessageAsync("abort", params);
        });
    }

    boolean isHandled() {
        return this.handled;
    }

    @Override
    public void resume(Route.ResumeOptions options) {
        this.resume(options, false);
    }

    void resume(Route.ResumeOptions options, boolean isFallback) {
        this.startHandling();
        this.applyOverrides(Utils.convertType(options, Route.FallbackOptions.class));
        this.withLogging("Route.resume", () -> this.resumeImpl(this.request().fallbackOverridesForResume(), isFallback));
    }

    @Override
    public void fallback(Route.FallbackOptions options) {
        this.fallbackCalled = true;
        if (this.handled) {
            throw new PlaywrightException("Route is already handled!");
        }
        this.applyOverrides(options);
        if (this.shouldResumeIfFallbackIsCalled) {
            this.resume(null, true);
        }
    }

    @Override
    public APIResponse fetch(Route.FetchOptions fetchOptions) {
        RequestOptionsImpl options = Utils.convertType(fetchOptions, RequestOptionsImpl.class);
        if (options == null) {
            options = new RequestOptionsImpl();
        }
        if (options.method == null) {
            options.method = this.request.method();
        }
        if (options.headers == null) {
            options.headers = this.request.headers();
        }
        options.data = fetchOptions != null && fetchOptions.postData != null ? fetchOptions.postData : (Object)this.request.postDataBuffer();
        if (fetchOptions != null && fetchOptions.timeout != null) {
            options.timeout = fetchOptions.timeout;
        }
        APIRequestContextImpl apiRequest = this.browserContext.request();
        String url = fetchOptions == null || fetchOptions.url == null ? this.request().url() : fetchOptions.url;
        return apiRequest.fetch(url, (RequestOptions)options);
    }

    private void applyOverrides(Route.FallbackOptions options) {
        if (options == null) {
            return;
        }
        RequestImpl.FallbackOverrides overrides = new RequestImpl.FallbackOverrides();
        overrides.url = options.url;
        overrides.method = options.method;
        overrides.headers = options.headers;
        if (options.postData != null) {
            overrides.postData = RouteImpl.getPostDataBytes(options.postData);
        }
        this.request().applyFallbackOverrides(overrides);
    }

    private void resumeImpl(RequestImpl.FallbackOverrides options, boolean isFallback) {
        JsonObject params = new JsonObject();
        if (options != null) {
            if (options.url != null) {
                params.addProperty("url", options.url);
            }
            if (options.method != null) {
                params.addProperty("method", options.method);
            }
            if (options.headers != null) {
                params.add("headers", (JsonElement)Serialization.toProtocol(options.headers));
            }
            if (options.postData != null) {
                String base64 = Base64.getEncoder().encodeToString(options.postData);
                params.addProperty("postData", base64);
            }
        }
        params.addProperty("requestUrl", this.request.initializer.get("url").getAsString());
        params.addProperty("isFallback", Boolean.valueOf(isFallback));
        this.sendMessageAsync("continue", params);
    }

    private static byte[] getPostDataBytes(Object postData) {
        if (postData instanceof byte[]) {
            return (byte[])postData;
        }
        if (postData instanceof String) {
            return ((String)postData).getBytes(StandardCharsets.UTF_8);
        }
        throw new PlaywrightException("postData must be either String or byte[], found: " + postData.getClass().getName());
    }

    @Override
    public void fulfill(Route.FulfillOptions options) {
        this.startHandling();
        this.withLogging("Route.fulfill", () -> this.fulfillImpl(options));
    }

    private void fulfillImpl(Route.FulfillOptions options) {
        if (options == null) {
            options = new Route.FulfillOptions();
        }
        Integer status = options.status;
        Map<String, String> headersOption = options.headers;
        String fetchResponseUid = null;
        if (options.response != null) {
            if (status == null) {
                status = options.response.status();
            }
            if (headersOption == null) {
                headersOption = options.response.headers();
            }
        }
        if (status == null) {
            status = 200;
        }
        String body = null;
        boolean isBase64 = false;
        int length = 0;
        if (options.path != null) {
            try {
                byte[] buffer = Files.readAllBytes(options.path);
                body = Base64.getEncoder().encodeToString(buffer);
                isBase64 = true;
                length = buffer.length;
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to read from file: " + options.path, e);
            }
        } else if (options.body != null) {
            body = options.body;
            isBase64 = false;
            length = body.getBytes().length;
        } else if (options.bodyBytes != null) {
            body = Base64.getEncoder().encodeToString(options.bodyBytes);
            isBase64 = true;
            length = options.bodyBytes.length;
        } else if (options.response != null) {
            APIResponseImpl response = (APIResponseImpl)options.response;
            if (response.context.connection == this.connection) {
                fetchResponseUid = response.fetchUid();
            } else {
                Object bodyBytes = response.body();
                body = Base64.getEncoder().encodeToString((byte[])bodyBytes);
                isBase64 = true;
                length = ((Object)bodyBytes).length;
            }
        }
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        if (headersOption != null) {
            for (Map.Entry entry : headersOption.entrySet()) {
                headers.put(((String)entry.getKey()).toLowerCase(), (String)entry.getValue());
            }
        }
        if (options.contentType != null) {
            headers.put("content-type", options.contentType);
        } else if (options.path != null) {
            headers.put("content-type", Utils.mimeType(options.path));
        }
        if (length != 0 && !headers.containsKey("content-length")) {
            headers.put("content-length", Integer.toString(length));
        }
        JsonObject params = new JsonObject();
        params.addProperty("status", (Number)status);
        params.add("headers", (JsonElement)Serialization.toProtocol(headers));
        params.addProperty("isBase64", Boolean.valueOf(isBase64));
        params.addProperty("body", body);
        if (fetchResponseUid != null) {
            params.addProperty("fetchResponseUid", fetchResponseUid);
        }
        params.addProperty("requestUrl", this.request.initializer.get("url").getAsString());
        this.sendMessageAsync("fulfill", params);
    }

    @Override
    public RequestImpl request() {
        return this.request;
    }

    void redirectNavigationRequest(String redirectURL) {
        this.startHandling();
        JsonObject params = new JsonObject();
        params.addProperty("url", redirectURL);
        this.sendMessageAsync("redirectNavigationRequest", params);
    }

    private void startHandling() {
        if (this.handled) {
            throw new PlaywrightException("Route is already handled!");
        }
        this.handled = true;
    }
}

