/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.Route;
import com.microsoft.playwright.impl.RouteImpl;
import com.microsoft.playwright.impl.UrlMatcher;
import com.microsoft.playwright.impl.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class Router {
    private List<RouteInfo> routes = new ArrayList<RouteInfo>();

    Router() {
    }

    void add(UrlMatcher matcher, Consumer<Route> handler, Integer times) {
        this.routes.add(0, new RouteInfo(matcher, handler, times));
    }

    void remove(UrlMatcher matcher, Consumer<Route> handler) {
        this.routes = this.routes.stream().filter(info -> !info.matcher.equals(matcher) || handler != null && info.handler != handler).collect(Collectors.toList());
    }

    void removeAll() {
        this.routes.clear();
    }

    HandleResult handle(RouteImpl route) {
        HandleResult result = HandleResult.NoMatchingHandler;
        Iterator<RouteInfo> it = this.routes.iterator();
        while (it.hasNext()) {
            RouteInfo info = it.next();
            if (!info.matcher.test(route.request().url())) continue;
            if (info.decrementRemainingCallCount()) {
                it.remove();
            }
            route.fallbackCalled = false;
            info.handle(route);
            if (route.isHandled()) {
                return HandleResult.Handled;
            }
            if (!route.fallbackCalled) {
                route.shouldResumeIfFallbackIsCalled = true;
                return HandleResult.PendingHandler;
            }
            result = HandleResult.Fallback;
        }
        return result;
    }

    JsonObject interceptionPatterns() {
        JsonArray jsonPatterns = new JsonArray();
        for (RouteInfo route : this.routes) {
            JsonObject jsonPattern = new JsonObject();
            Object urlFilter = route.matcher.rawSource;
            if (urlFilter instanceof String) {
                jsonPattern.addProperty("glob", (String)urlFilter);
            } else if (urlFilter instanceof Pattern) {
                Pattern pattern = (Pattern)urlFilter;
                jsonPattern.addProperty("regexSource", pattern.pattern());
                jsonPattern.addProperty("regexFlags", Utils.toJsRegexFlags(pattern));
            } else {
                jsonPattern.addProperty("glob", "**/*");
                jsonPatterns = new JsonArray();
                jsonPatterns.add((JsonElement)jsonPattern);
                break;
            }
            jsonPatterns.add((JsonElement)jsonPattern);
        }
        JsonObject result = new JsonObject();
        result.add("patterns", (JsonElement)jsonPatterns);
        return result;
    }

    static enum HandleResult {
        NoMatchingHandler,
        Handled,
        Fallback,
        PendingHandler;

    }

    private static class RouteInfo {
        final UrlMatcher matcher;
        final Consumer<Route> handler;
        Integer times;

        RouteInfo(UrlMatcher matcher, Consumer<Route> handler, Integer times) {
            this.matcher = matcher;
            this.handler = handler;
            this.times = times;
        }

        void handle(RouteImpl route) {
            this.handler.accept(route);
        }

        boolean decrementRemainingCallCount() {
            if (this.times == null) {
                return false;
            }
            this.times = this.times - 1;
            return this.times <= 0;
        }
    }
}

