/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.JSHandle;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.SerializedValue;
import com.microsoft.playwright.impl.TargetClosedError;
import java.util.HashMap;
import java.util.Map;

public class JSHandleImpl
extends ChannelOwner
implements JSHandle {
    private String preview;

    public JSHandleImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
        this.preview = initializer.get("preview").getAsString();
    }

    @Override
    public ElementHandle asElement() {
        return null;
    }

    @Override
    public void dispose() {
        this.withLogging("JSHandle.dispose", () -> {
            try {
                this.sendMessage("dispose");
            }
            catch (TargetClosedError targetClosedError) {
                // empty catch block
            }
        });
    }

    @Override
    public Object evaluate(String pageFunction, Object arg) {
        return this.withLogging("JSHandle.evaluate", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("expression", pageFunction);
            params.addProperty("world", "main");
            params.add("arg", Serialization.gson().toJsonTree((Object)Serialization.serializeArgument(arg)));
            JsonElement json = this.sendMessage("evaluateExpression", params);
            SerializedValue value = (SerializedValue)Serialization.gson().fromJson(json.getAsJsonObject().get("value"), SerializedValue.class);
            return Serialization.deserialize(value);
        });
    }

    @Override
    public JSHandle evaluateHandle(String pageFunction, Object arg) {
        return this.withLogging("JSHandle.evaluateHandle", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("expression", pageFunction);
            params.addProperty("world", "main");
            params.add("arg", Serialization.gson().toJsonTree((Object)Serialization.serializeArgument(arg)));
            JsonElement json = this.sendMessage("evaluateExpressionHandle", params);
            return (JSHandle)this.connection.getExistingObject(json.getAsJsonObject().getAsJsonObject("handle").get("guid").getAsString());
        });
    }

    @Override
    public Map<String, JSHandle> getProperties() {
        return this.withLogging("JSHandle.getProperties", () -> {
            JsonObject json = this.sendMessage("getPropertyList").getAsJsonObject();
            HashMap<String, JSHandle> result = new HashMap<String, JSHandle>();
            for (JsonElement e : json.getAsJsonArray("properties")) {
                JsonObject item = e.getAsJsonObject();
                JSHandle value = (JSHandle)this.connection.getExistingObject(item.getAsJsonObject("value").get("guid").getAsString());
                result.put(item.get("name").getAsString(), value);
            }
            return result;
        });
    }

    @Override
    public JSHandle getProperty(String propertyName) {
        return this.withLogging("JSHandle.getProperty", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("name", propertyName);
            JsonObject json = this.sendMessage("getProperty", params).getAsJsonObject();
            return (JSHandle)this.connection.getExistingObject(json.getAsJsonObject("handle").get("guid").getAsString());
        });
    }

    @Override
    public Object jsonValue() {
        return this.withLogging("JSHandle.jsonValue", () -> {
            JsonObject json = this.sendMessage("jsonValue").getAsJsonObject();
            SerializedValue value = (SerializedValue)Serialization.gson().fromJson(json.get("value"), SerializedValue.class);
            return Serialization.deserialize(value);
        });
    }

    @Override
    void handleEvent(String event, JsonObject parameters) {
        if ("previewUpdated".equals(event)) {
            this.preview = parameters.get("preview").getAsString();
        }
        super.handleEvent(event, parameters);
    }

    public String toString() {
        return this.preview;
    }
}

