/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright;

import com.microsoft.playwright.APIRequestContext;
import com.microsoft.playwright.options.ClientCertificate;
import com.microsoft.playwright.options.HttpCredentials;
import com.microsoft.playwright.options.Proxy;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public interface APIRequest {
    default public APIRequestContext newContext() {
        return this.newContext(null);
    }

    public APIRequestContext newContext(NewContextOptions var1);

    public static class NewContextOptions {
        public String baseURL;
        public List<ClientCertificate> clientCertificates;
        public Map<String, String> extraHTTPHeaders;
        public HttpCredentials httpCredentials;
        public Boolean ignoreHTTPSErrors;
        public Proxy proxy;
        public String storageState;
        public Path storageStatePath;
        public Double timeout;
        public String userAgent;

        public NewContextOptions setBaseURL(String baseURL) {
            this.baseURL = baseURL;
            return this;
        }

        public NewContextOptions setClientCertificates(List<ClientCertificate> clientCertificates) {
            this.clientCertificates = clientCertificates;
            return this;
        }

        public NewContextOptions setExtraHTTPHeaders(Map<String, String> extraHTTPHeaders) {
            this.extraHTTPHeaders = extraHTTPHeaders;
            return this;
        }

        public NewContextOptions setHttpCredentials(String username, String password) {
            return this.setHttpCredentials(new HttpCredentials(username, password));
        }

        public NewContextOptions setHttpCredentials(HttpCredentials httpCredentials) {
            this.httpCredentials = httpCredentials;
            return this;
        }

        public NewContextOptions setIgnoreHTTPSErrors(boolean ignoreHTTPSErrors) {
            this.ignoreHTTPSErrors = ignoreHTTPSErrors;
            return this;
        }

        public NewContextOptions setProxy(String server) {
            return this.setProxy(new Proxy(server));
        }

        public NewContextOptions setProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public NewContextOptions setStorageState(String storageState) {
            this.storageState = storageState;
            return this;
        }

        public NewContextOptions setStorageStatePath(Path storageStatePath) {
            this.storageStatePath = storageStatePath;
            return this;
        }

        public NewContextOptions setTimeout(double timeout) {
            this.timeout = timeout;
            return this;
        }

        public NewContextOptions setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }
    }
}

