/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.APIRequest;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.APIRequestContextImpl;
import com.microsoft.playwright.impl.PlaywrightImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.options.ClientCertificate;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;

class APIRequestImpl
implements APIRequest {
    private final PlaywrightImpl playwright;

    APIRequestImpl(PlaywrightImpl playwright) {
        this.playwright = playwright;
    }

    @Override
    public APIRequestContextImpl newContext(APIRequest.NewContextOptions options) {
        return this.playwright.withLogging("APIRequest.newContext", () -> this.newContextImpl(options));
    }

    private APIRequestContextImpl newContextImpl(APIRequest.NewContextOptions options) {
        options = options == null ? new APIRequest.NewContextOptions() : Utils.clone(options);
        if (options.storageStatePath != null) {
            try {
                byte[] bytes = Files.readAllBytes(options.storageStatePath);
                options.storageState = new String(bytes, StandardCharsets.UTF_8);
                options.storageStatePath = null;
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to read storage state from file", e);
            }
        }
        JsonObject storageState = null;
        if (options.storageState != null) {
            storageState = (JsonObject)new Gson().fromJson(options.storageState, JsonObject.class);
            options.storageState = null;
        }
        List<ClientCertificate> clientCertificateList = options.clientCertificates;
        options.clientCertificates = null;
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        if (storageState != null) {
            params.add("storageState", (JsonElement)storageState);
        }
        Utils.addToProtocol(params, clientCertificateList);
        JsonObject result = this.playwright.sendMessage("newRequest", params).getAsJsonObject();
        APIRequestContextImpl context = (APIRequestContextImpl)this.playwright.connection.getExistingObject(result.getAsJsonObject("request").get("guid").getAsString());
        return context;
    }
}

