/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.Connection;
import com.microsoft.playwright.impl.Logger;
import com.microsoft.playwright.impl.LoggingSupport;
import com.microsoft.playwright.impl.WaitForEventLogger;
import com.microsoft.playwright.impl.Waitable;
import com.microsoft.playwright.impl.WaitableResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

class ChannelOwner
extends LoggingSupport {
    final Connection connection;
    private ChannelOwner parent;
    private final Map<String, ChannelOwner> objects = new HashMap<String, ChannelOwner>();
    final String type;
    final String guid;
    final JsonObject initializer;
    private boolean wasCollected;
    private boolean isInternalType;

    protected ChannelOwner(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        this(parent.connection, parent, type, guid, initializer);
    }

    protected ChannelOwner(Connection connection, String type, String guid) {
        this(connection, null, type, guid, new JsonObject());
    }

    private ChannelOwner(Connection connection, ChannelOwner parent, String type, String guid, JsonObject initializer) {
        this.connection = connection;
        this.parent = parent;
        this.type = type;
        this.guid = guid;
        this.initializer = initializer;
        connection.registerObject(guid, this);
        if (parent != null) {
            parent.objects.put(guid, this);
        }
    }

    void markAsInternalType() {
        this.isInternalType = true;
    }

    void disposeChannelOwner(boolean wasGarbageCollected) {
        if (this.parent != null) {
            this.parent.objects.remove(this.guid);
        }
        this.connection.unregisterObject(this.guid);
        this.wasCollected = wasGarbageCollected;
        for (ChannelOwner child : new ArrayList<ChannelOwner>(this.objects.values())) {
            child.disposeChannelOwner(wasGarbageCollected);
        }
        this.objects.clear();
    }

    void adopt(ChannelOwner child) {
        child.parent.objects.remove(child.guid);
        this.objects.put(child.guid, child);
        child.parent = this;
    }

    <T> T withWaitLogging(String apiName, Function<Logger, T> code) {
        return new WaitForEventLogger<T>(this, apiName, code).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T> T withLogging(String apiName, Supplier<T> code) {
        if (this.isInternalType) {
            apiName = null;
        }
        String previousApiName = this.connection.setApiName(apiName);
        try {
            T t = super.withLogging(apiName, code);
            return t;
        }
        finally {
            this.connection.setApiName(previousApiName);
        }
    }

    WaitableResult<JsonElement> sendMessageAsync(String method) {
        return this.sendMessageAsync(method, new JsonObject());
    }

    WaitableResult<JsonElement> sendMessageAsync(String method, JsonObject params) {
        this.checkNotCollected();
        return this.connection.sendMessageAsync(this.guid, method, params);
    }

    JsonElement sendMessage(String method) {
        return this.sendMessage(method, new JsonObject());
    }

    JsonElement sendMessage(String method, JsonObject params) {
        this.checkNotCollected();
        return this.connection.sendMessage(this.guid, method, params);
    }

    private void checkNotCollected() {
        if (this.wasCollected) {
            throw new PlaywrightException("The object has been collected to prevent unbounded heap growth.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T runUntil(Runnable code, Waitable<T> waitable) {
        try {
            code.run();
            while (!waitable.isDone()) {
                this.connection.processOneMessage();
            }
            T t = waitable.get();
            return t;
        }
        finally {
            waitable.dispose();
        }
    }

    void handleEvent(String event, JsonObject parameters) {
    }

    JsonObject toProtocolRef() {
        JsonObject json = new JsonObject();
        json.addProperty("guid", this.guid);
        return json;
    }
}

