/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.Request;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.FrameImpl;
import com.microsoft.playwright.impl.RawHeaders;
import com.microsoft.playwright.impl.ResponseImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.options.HttpHeader;
import com.microsoft.playwright.options.Sizes;
import com.microsoft.playwright.options.Timing;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public class RequestImpl
extends ChannelOwner
implements Request {
    private final byte[] postData;
    private RequestImpl redirectedFrom;
    private RequestImpl redirectedTo;
    private final RawHeaders headers;
    private RawHeaders rawHeaders;
    String failure;
    Timing timing;
    boolean didFailOrFinish;
    private FallbackOverrides fallbackOverrides;

    RequestImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
        if (initializer.has("redirectedFrom")) {
            this.redirectedFrom = (RequestImpl)this.connection.getExistingObject(initializer.getAsJsonObject("redirectedFrom").get("guid").getAsString());
            this.redirectedFrom.redirectedTo = this;
        }
        this.headers = new RawHeaders(Arrays.asList((HttpHeader[])Serialization.gson().fromJson((JsonElement)initializer.getAsJsonArray("headers"), HttpHeader[].class)));
        this.postData = (byte[])(initializer.has("postData") ? Base64.getDecoder().decode(initializer.get("postData").getAsString()) : null);
    }

    @Override
    public Map<String, String> allHeaders() {
        return this.withLogging("Request.allHeaders", () -> this.getRawHeaders().headers());
    }

    @Override
    public String failure() {
        return this.failure;
    }

    @Override
    public FrameImpl frame() {
        FrameImpl frame = (FrameImpl)this.connection.getExistingObject(this.initializer.getAsJsonObject("frame").get("guid").getAsString());
        if (frame.page == null) {
            throw new PlaywrightException("Frame for this navigation request is not available, because the request\nwas issued before the frame is created. You can check whether the request\nis a navigation request by calling isNavigationRequest() method.");
        }
        return frame;
    }

    @Override
    public Map<String, String> headers() {
        if (this.fallbackOverrides != null && this.fallbackOverrides.headers != null) {
            return new RawHeaders(Utils.toHeadersList(this.fallbackOverrides.headers)).headers();
        }
        return this.headers.headers();
    }

    @Override
    public List<HttpHeader> headersArray() {
        return this.withLogging("Request.headersArray", () -> this.getRawHeaders().headersArray());
    }

    @Override
    public String headerValue(String name) {
        return this.withLogging("Request.headerValue", () -> this.getRawHeaders().get(name));
    }

    @Override
    public boolean isNavigationRequest() {
        return this.initializer.get("isNavigationRequest").getAsBoolean();
    }

    @Override
    public String method() {
        if (this.fallbackOverrides != null && this.fallbackOverrides.method != null) {
            return this.fallbackOverrides.method;
        }
        return this.initializer.get("method").getAsString();
    }

    @Override
    public String postData() {
        byte[] buffer = this.postDataBuffer();
        if (buffer == null) {
            return null;
        }
        return new String(buffer, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] postDataBuffer() {
        if (this.fallbackOverrides != null && this.fallbackOverrides.postData != null) {
            return this.fallbackOverrides.postData;
        }
        return this.postData;
    }

    @Override
    public Request redirectedFrom() {
        return this.redirectedFrom;
    }

    @Override
    public Request redirectedTo() {
        return this.redirectedTo;
    }

    @Override
    public String resourceType() {
        return this.initializer.get("resourceType").getAsString();
    }

    @Override
    public ResponseImpl response() {
        return this.withLogging("Request.response", () -> {
            JsonObject result = this.sendMessage("response").getAsJsonObject();
            if (!result.has("response")) {
                return null;
            }
            return (ResponseImpl)this.connection.getExistingObject(result.getAsJsonObject("response").get("guid").getAsString());
        });
    }

    @Override
    public Sizes sizes() {
        return this.withLogging("Request.sizes", () -> {
            ResponseImpl response = this.response();
            if (response == null) {
                throw new PlaywrightException("Unable to fetch sizes for failed request");
            }
            JsonObject json = response.sendMessage("sizes").getAsJsonObject();
            return (Sizes)Serialization.gson().fromJson((JsonElement)json.getAsJsonObject("sizes"), Sizes.class);
        });
    }

    @Override
    public Timing timing() {
        return this.timing;
    }

    @Override
    public String url() {
        if (this.fallbackOverrides != null && this.fallbackOverrides.url != null) {
            return this.fallbackOverrides.url;
        }
        return this.initializer.get("url").getAsString();
    }

    Request finalRequest() {
        return this.redirectedTo != null ? this.redirectedTo.finalRequest() : this;
    }

    private RawHeaders getRawHeaders() {
        if (this.fallbackOverrides != null && this.fallbackOverrides.headers != null) {
            return new RawHeaders(Utils.toHeadersList(this.fallbackOverrides.headers));
        }
        if (this.rawHeaders != null) {
            return this.rawHeaders;
        }
        JsonArray rawHeadersJson = this.withLogging("Request.allHeaders", () -> {
            JsonObject result = this.sendMessage("rawRequestHeaders").getAsJsonObject();
            return result.getAsJsonArray("headers");
        });
        this.rawHeaders = new RawHeaders(Arrays.asList((HttpHeader[])Serialization.gson().fromJson((JsonElement)rawHeadersJson, HttpHeader[].class)));
        return this.rawHeaders;
    }

    void applyFallbackOverrides(FallbackOverrides overrides) {
        if (this.fallbackOverrides == null) {
            this.fallbackOverrides = new FallbackOverrides();
        }
        if (overrides.url != null) {
            this.fallbackOverrides.url = overrides.url;
        }
        if (overrides.method != null) {
            this.fallbackOverrides.method = overrides.method;
        }
        if (overrides.headers != null) {
            this.fallbackOverrides.headers = overrides.headers;
        }
        if (overrides.postData != null) {
            this.fallbackOverrides.postData = overrides.postData;
        }
    }

    FallbackOverrides fallbackOverridesForResume() {
        return this.fallbackOverrides;
    }

    static class FallbackOverrides {
        String url;
        String method;
        byte[] postData;
        Map<String, String> headers;

        FallbackOverrides() {
        }
    }
}

