/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonObject;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.WebSocketFrame;
import com.microsoft.playwright.WebSocketRoute;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.WebSocketFrameImpl;
import java.util.Base64;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

class WebSocketRouteImpl
extends ChannelOwner
implements WebSocketRoute {
    private Consumer<WebSocketFrame> onPageMessage;
    private BiConsumer<Integer, String> onPageClose;
    private Consumer<WebSocketFrame> onServerMessage;
    private BiConsumer<Integer, String> onServerClose;
    private boolean connected;
    private WebSocketRoute server = new WebSocketRoute(){

        @Override
        public void close(WebSocketRoute.CloseOptions options) {
            if (options == null) {
                options = new WebSocketRoute.CloseOptions();
            }
            JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
            params.addProperty("wasClean", Boolean.valueOf(true));
            WebSocketRouteImpl.this.sendMessageAsync("closeServer", params);
        }

        @Override
        public WebSocketRoute connectToServer() {
            throw new PlaywrightException("connectToServer must be called on the page-side WebSocketRoute");
        }

        @Override
        public void onClose(BiConsumer<Integer, String> handler) {
            WebSocketRouteImpl.this.onServerClose = handler;
        }

        @Override
        public void onMessage(Consumer<WebSocketFrame> handler) {
            WebSocketRouteImpl.this.onServerMessage = handler;
        }

        @Override
        public void send(String message) {
            JsonObject params = new JsonObject();
            params.addProperty("message", message);
            params.addProperty("isBase64", Boolean.valueOf(false));
            WebSocketRouteImpl.this.sendMessageAsync("sendToServer", params);
        }

        @Override
        public void send(byte[] message) {
            JsonObject params = new JsonObject();
            String base64 = Base64.getEncoder().encodeToString(message);
            params.addProperty("message", base64);
            params.addProperty("isBase64", Boolean.valueOf(true));
            WebSocketRouteImpl.this.sendMessageAsync("sendToServer", params);
        }

        @Override
        public String url() {
            return WebSocketRouteImpl.this.initializer.get("url").getAsString();
        }
    };

    WebSocketRouteImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
        this.markAsInternalType();
    }

    @Override
    public void close(WebSocketRoute.CloseOptions options) {
        if (options == null) {
            options = new WebSocketRoute.CloseOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("wasClean", Boolean.valueOf(true));
        this.sendMessageAsync("closePage", params);
    }

    @Override
    public WebSocketRoute connectToServer() {
        if (this.connected) {
            throw new PlaywrightException("Already connected to the server");
        }
        this.connected = true;
        this.sendMessageAsync("connect");
        return this.server;
    }

    @Override
    public void onClose(BiConsumer<Integer, String> handler) {
        this.onPageClose = handler;
    }

    @Override
    public void onMessage(Consumer<WebSocketFrame> handler) {
        this.onPageMessage = handler;
    }

    @Override
    public void send(String message) {
        JsonObject params = new JsonObject();
        params.addProperty("message", message);
        params.addProperty("isBase64", Boolean.valueOf(false));
        this.sendMessageAsync("sendToPage", params);
    }

    @Override
    public void send(byte[] message) {
        JsonObject params = new JsonObject();
        String base64 = Base64.getEncoder().encodeToString(message);
        params.addProperty("message", base64);
        params.addProperty("isBase64", Boolean.valueOf(true));
        this.sendMessageAsync("sendToPage", params);
    }

    @Override
    public String url() {
        return this.initializer.get("url").getAsString();
    }

    void afterHandle() {
        if (this.connected) {
            return;
        }
        this.sendMessageAsync("ensureOpened");
    }

    @Override
    protected void handleEvent(String event, JsonObject params) {
        if ("messageFromPage".equals(event)) {
            String message = params.get("message").getAsString();
            boolean isBase64 = params.get("isBase64").getAsBoolean();
            if (this.onPageMessage != null) {
                this.onPageMessage.accept(new WebSocketFrameImpl(message, isBase64));
            } else if (this.connected) {
                JsonObject messageParams = new JsonObject();
                messageParams.addProperty("message", message);
                messageParams.addProperty("isBase64", Boolean.valueOf(isBase64));
                this.sendMessageAsync("sendToServer", messageParams);
            }
        } else if ("messageFromServer".equals(event)) {
            String message = params.get("message").getAsString();
            boolean isBase64 = params.get("isBase64").getAsBoolean();
            if (this.onServerMessage != null) {
                this.onServerMessage.accept(new WebSocketFrameImpl(message, isBase64));
            } else {
                JsonObject messageParams = new JsonObject();
                messageParams.addProperty("message", message);
                messageParams.addProperty("isBase64", Boolean.valueOf(isBase64));
                this.sendMessageAsync("sendToPage", messageParams);
            }
        } else if ("closePage".equals(event)) {
            int code = params.get("code").getAsInt();
            String reason = params.get("reason").getAsString();
            boolean wasClean = params.get("wasClean").getAsBoolean();
            if (this.onPageClose != null) {
                this.onPageClose.accept(code, reason);
            } else {
                JsonObject closeParams = new JsonObject();
                closeParams.addProperty("code", (Number)code);
                closeParams.addProperty("reason", reason);
                closeParams.addProperty("wasClean", Boolean.valueOf(wasClean));
                this.sendMessageAsync("closeServer", closeParams);
            }
        } else if ("closeServer".equals(event)) {
            int code = params.get("code").getAsInt();
            String reason = params.get("reason").getAsString();
            boolean wasClean = params.get("wasClean").getAsBoolean();
            if (this.onServerClose != null) {
                this.onServerClose.accept(code, reason);
            } else {
                JsonObject closeParams = new JsonObject();
                closeParams.addProperty("code", (Number)code);
                closeParams.addProperty("reason", reason);
                closeParams.addProperty("wasClean", Boolean.valueOf(wasClean));
                this.sendMessageAsync("closePage", closeParams);
            }
        }
    }
}

