/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl.junit;

import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.junit.ExtensionUtils;
import com.microsoft.playwright.junit.Options;
import com.microsoft.playwright.junit.UsePlaywright;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class OptionsExtension
implements AfterAllCallback {
    private static final ThreadLocal<Options> threadLocalOptions = new ThreadLocal();

    public void afterAll(ExtensionContext extensionContext) {
        threadLocalOptions.remove();
    }

    static Options getOptions(ExtensionContext extensionContext) {
        Options options = threadLocalOptions.get();
        if (options != null) {
            return options;
        }
        UsePlaywright usePlaywrightAnnotation = ExtensionUtils.getUsePlaywrightAnnotation(extensionContext);
        try {
            options = usePlaywrightAnnotation.value().newInstance().getOptions();
            threadLocalOptions.set(options);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new PlaywrightException("Failed to create options", e);
        }
        return options;
    }
}

