/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.domain.impl;

import com.mmnaseri.utils.spring.data.domain.RepositoryMetadata;
import com.mmnaseri.utils.spring.data.domain.impl.AbstractRepositoryMetadataResolver;
import com.mmnaseri.utils.spring.data.domain.impl.ImmutableRepositoryMetadata;
import com.mmnaseri.utils.spring.data.error.RepositoryDefinitionException;
import org.springframework.data.repository.RepositoryDefinition;

public class AnnotationRepositoryMetadataResolver
extends AbstractRepositoryMetadataResolver {
    @Override
    protected RepositoryMetadata resolveFromInterface(Class<?> repositoryInterface) {
        RepositoryDefinition definition = repositoryInterface.getAnnotation(RepositoryDefinition.class);
        if (definition == null) {
            throw new RepositoryDefinitionException(repositoryInterface, "Expected the repository to be annotated with @RepositoryDefinition");
        }
        Class entityType = definition.domainClass();
        Class idType = definition.idClass();
        String idProperty = this.resolveIdProperty(entityType, idType);
        return new ImmutableRepositoryMetadata(idType, entityType, repositoryInterface, idProperty);
    }
}

