/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.domain.impl;

import com.mmnaseri.utils.spring.data.domain.Operator;
import com.mmnaseri.utils.spring.data.domain.OperatorContext;
import com.mmnaseri.utils.spring.data.domain.impl.ImmutableOperator;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.ContainingMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.EndingWithMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.IsBetweenMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.IsEqualToMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.IsFalseMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.IsGreaterThanMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.IsGreaterThanOrEqualToMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.IsInMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.IsLessThanMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.IsLessThanOrEqualToMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.IsLikeMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.IsNotBetweenMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.IsNotInMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.IsNotLikeMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.IsNotMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.IsNotNullMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.IsNullMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.IsTrueMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.RegexMatcher;
import com.mmnaseri.utils.spring.data.domain.impl.matchers.StartingWithMatcher;
import com.mmnaseri.utils.spring.data.error.DuplicateOperatorException;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultOperatorContext
implements OperatorContext {
    private static final Log log = LogFactory.getLog(DefaultOperatorContext.class);
    private final Set<Operator> operators = new CopyOnWriteArraySet<Operator>();

    public DefaultOperatorContext() {
        this(true);
    }

    public DefaultOperatorContext(boolean registerDefaults) {
        if (registerDefaults) {
            log.info((Object)"Registering all the default operators");
            this.operators.add(new ImmutableOperator("AFTER", 1, new IsGreaterThanMatcher(), "After", "IsAfter"));
            this.operators.add(new ImmutableOperator("BEFORE", 1, new IsLessThanMatcher(), "Before", "IsBefore"));
            this.operators.add(new ImmutableOperator("CONTAINING", 1, new ContainingMatcher(), "Containing", "IsContaining", "Contains"));
            this.operators.add(new ImmutableOperator("BETWEEN", 2, new IsBetweenMatcher(), "Between", "IsBetween"));
            this.operators.add(new ImmutableOperator("NOT_BETWEEN", 2, new IsNotBetweenMatcher(), "NotBetween", "IsNotBetween"));
            this.operators.add(new ImmutableOperator("ENDING_WITH", 1, new EndingWithMatcher(), "EndingWith", "IsEndingWith", "EndsWith"));
            this.operators.add(new ImmutableOperator("FALSE", 0, new IsFalseMatcher(), "False", "IsFalse"));
            this.operators.add(new ImmutableOperator("GREATER_THAN", 1, new IsGreaterThanMatcher(), "GreaterThan", "IsGreaterThan"));
            this.operators.add(new ImmutableOperator("GREATER_THAN_EQUALS", 1, new IsGreaterThanOrEqualToMatcher(), "GreaterThanEqual", "IsGreaterThanEqual"));
            this.operators.add(new ImmutableOperator("IN", 1, new IsInMatcher(), "In", "IsIn"));
            this.operators.add(new ImmutableOperator("IS", 1, new IsEqualToMatcher(), "Is", "EqualTo", "IsEqualTo", "Equals"));
            this.operators.add(new ImmutableOperator("NOT_NULL", 0, new IsNotNullMatcher(), "NotNull", "IsNotNull"));
            this.operators.add(new ImmutableOperator("NULL", 0, new IsNullMatcher(), "Null", "IsNull"));
            this.operators.add(new ImmutableOperator("LESS_THAN", 1, new IsLessThanMatcher(), "LessThan", "IsLessThan"));
            this.operators.add(new ImmutableOperator("LESS_THAN_EQUAL", 1, new IsLessThanOrEqualToMatcher(), "LessThanEqual", "IsLessThanEqual"));
            this.operators.add(new ImmutableOperator("LIKE", 1, new IsLikeMatcher(), "Like", "IsLike"));
            this.operators.add(new ImmutableOperator("NEAR", 1, null, "Near", "IsNear"));
            this.operators.add(new ImmutableOperator("NOT", 1, new IsNotMatcher(), "IsNot", "Not", "IsNotEqualTo", "DoesNotEqual"));
            this.operators.add(new ImmutableOperator("NOT_IN", 1, new IsNotInMatcher(), "NotIn", "IsNotIn"));
            this.operators.add(new ImmutableOperator("NOT_LIKE", 1, new IsNotLikeMatcher(), "NotLike", "IsNotLike"));
            this.operators.add(new ImmutableOperator("REGEX", 1, new RegexMatcher(), "Regex", "MatchesRegex", "Matches"));
            this.operators.add(new ImmutableOperator("STARTING_WITH", 1, new StartingWithMatcher(), "StartingWith", "IsStartingWith", "StartsWith"));
            this.operators.add(new ImmutableOperator("TRUE", 0, new IsTrueMatcher(), "True", "IsTrue"));
        }
    }

    @Override
    public void register(Operator operator) {
        log.info((Object)("Registering operator " + operator.getName() + " which will respond to suffixes " + Arrays.toString(operator.getTokens())));
        for (Operator item : this.operators) {
            for (String token : item.getTokens()) {
                for (String newToken : operator.getTokens()) {
                    if (!newToken.equals(token)) continue;
                    throw new DuplicateOperatorException(item, token);
                }
            }
        }
        this.operators.add(operator);
    }

    @Override
    public Operator getBySuffix(String suffix) {
        for (Operator operator : this.operators) {
            for (String token : operator.getTokens()) {
                if (!token.equals(suffix)) continue;
                return operator;
            }
        }
        return null;
    }
}

