/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.domain.impl;

import com.mmnaseri.utils.spring.data.error.InvalidArgumentException;
import com.mmnaseri.utils.spring.data.query.NullHandling;
import com.mmnaseri.utils.spring.data.query.Order;
import com.mmnaseri.utils.spring.data.query.Sort;
import com.mmnaseri.utils.spring.data.query.SortDirection;
import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import java.util.Comparator;
import java.util.List;

public class PropertyComparator
implements Comparator<Object> {
    private static final NullHandling DEFAULT_NULL_HANDLING = NullHandling.NULLS_LAST;
    private final NullHandling nullHandling;
    private final String property;
    private final SortDirection direction;

    PropertyComparator(Order order) {
        this.nullHandling = order.getNullHandling() == null || NullHandling.DEFAULT.equals((Object)order.getNullHandling()) ? DEFAULT_NULL_HANDLING : order.getNullHandling();
        this.property = order.getProperty();
        this.direction = order.getDirection();
    }

    @Override
    public int compare(Object first, Object second) {
        Object firstValue = this.safeReadPropertyValue(first);
        Object secondValue = this.safeReadPropertyValue(second);
        int comparison = firstValue == null || secondValue == null ? this.compareIfEitherIsNull(firstValue, secondValue) : this.compareIfCompatible(firstValue, secondValue);
        return comparison * (SortDirection.DESCENDING.equals((Object)this.direction) ? -1 : 1);
    }

    private Object safeReadPropertyValue(Object object) {
        Object firstValue;
        try {
            firstValue = PropertyUtils.getPropertyValue(object, this.property);
        }
        catch (Exception e) {
            throw new InvalidArgumentException("Failed to read property value for " + this.property + " on " + object, e);
        }
        return firstValue;
    }

    private int compareIfEitherIsNull(Object first, Object second) {
        if (first == null && second != null) {
            return NullHandling.NULLS_FIRST.equals((Object)this.nullHandling) ? -1 : 1;
        }
        if (first != null) {
            return NullHandling.NULLS_FIRST.equals((Object)this.nullHandling) ? 1 : -1;
        }
        return 0;
    }

    private int compareIfCompatible(Object first, Object second) {
        this.checkForComparable(first, second);
        if (first.getClass().isInstance(second)) {
            return ((Comparable)first).compareTo(second);
        }
        if (second.getClass().isInstance(first)) {
            return ((Comparable)second).compareTo(first) * -1;
        }
        throw new InvalidArgumentException("Values for were not of the same type for property: " + this.property);
    }

    private void checkForComparable(Object first, Object second) {
        if (!(first instanceof Comparable) || !(second instanceof Comparable)) {
            throw new InvalidArgumentException("Expected both values to be comparable for property: " + this.property);
        }
    }

    public static void sort(List<?> collection, Sort sort) {
        for (int i = sort.getOrders().size() - 1; i >= 0; --i) {
            collection.sort(new PropertyComparator(sort.getOrders().get(i)));
        }
    }
}

