/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.domain.impl.id;

import com.mmnaseri.utils.spring.data.domain.IdPropertyResolver;
import com.mmnaseri.utils.spring.data.domain.impl.id.IdPropertyResolverUtils;
import com.mmnaseri.utils.spring.data.error.MultipleIdPropertiesException;
import com.mmnaseri.utils.spring.data.error.PropertyTypeMismatchException;
import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.util.ReflectionUtils;

public class AnnotatedFieldIdPropertyResolver
implements IdPropertyResolver {
    @Override
    public String resolve(Class<?> entityType, Class<?> idType) {
        AtomicReference found = new AtomicReference();
        ReflectionUtils.doWithFields(entityType, field -> {
            if (IdPropertyResolverUtils.isAnnotated(field)) {
                if (found.get() == null) {
                    found.set(field);
                } else {
                    throw new MultipleIdPropertiesException(entityType);
                }
            }
        });
        Field idAnnotatedField = (Field)found.get();
        if (idAnnotatedField != null) {
            if (!PropertyUtils.getTypeOf(idType).isAssignableFrom(PropertyUtils.getTypeOf(idAnnotatedField.getType()))) {
                throw new PropertyTypeMismatchException(entityType, idAnnotatedField.getName(), idType, idAnnotatedField.getType());
            }
            return idAnnotatedField.getName();
        }
        return null;
    }
}

