/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.domain.impl.id;

import com.mmnaseri.utils.spring.data.domain.IdPropertyResolver;
import com.mmnaseri.utils.spring.data.domain.impl.id.AnnotatedFieldIdPropertyResolver;
import com.mmnaseri.utils.spring.data.domain.impl.id.AnnotatedGetterIdPropertyResolver;
import com.mmnaseri.utils.spring.data.domain.impl.id.NamedFieldIdPropertyResolver;
import com.mmnaseri.utils.spring.data.domain.impl.id.NamedGetterIdPropertyResolver;
import com.mmnaseri.utils.spring.data.error.NoIdPropertyException;
import com.mmnaseri.utils.spring.data.error.PrimitiveIdTypeException;
import com.mmnaseri.utils.spring.data.query.PropertyDescriptor;
import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import com.mmnaseri.utils.spring.data.tools.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityIdPropertyResolver
implements IdPropertyResolver {
    private static final Log log = LogFactory.getLog(EntityIdPropertyResolver.class);
    private final AnnotatedGetterIdPropertyResolver annotatedGetterIdPropertyResolver = new AnnotatedGetterIdPropertyResolver();
    private final AnnotatedFieldIdPropertyResolver annotatedFieldIdPropertyResolver = new AnnotatedFieldIdPropertyResolver();
    private final NamedGetterIdPropertyResolver namedGetterIdPropertyResolver = new NamedGetterIdPropertyResolver();
    private final NamedFieldIdPropertyResolver namedFieldIdPropertyResolver = new NamedFieldIdPropertyResolver();

    @Override
    public String resolve(Class<?> entityType, Class<?> idType) {
        log.info((Object)("Trying to resolve the ID property for entity " + entityType + " using the annotated getter method"));
        String idProperty = this.annotatedGetterIdPropertyResolver.resolve(entityType, idType);
        if (idProperty == null) {
            log.info((Object)("Trying to resolve the ID property for entity " + entityType + " using the annotated ID field"));
            idProperty = this.annotatedFieldIdPropertyResolver.resolve(entityType, idType);
        }
        if (idProperty == null) {
            log.info((Object)("Trying to resolve the ID property for entity " + entityType + " using the getter method"));
            idProperty = this.namedGetterIdPropertyResolver.resolve(entityType, idType);
        }
        if (idProperty == null) {
            log.info((Object)("Trying to resolve the ID property for entity " + entityType + " using the field"));
            idProperty = this.namedFieldIdPropertyResolver.resolve(entityType, idType);
        }
        if (idProperty == null) {
            log.error((Object)("No ID property was found for entity " + entityType));
            throw new NoIdPropertyException(entityType);
        }
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(entityType, StringUtils.capitalize(idProperty));
        if (descriptor.getType().isPrimitive()) {
            throw new PrimitiveIdTypeException(entityType, idProperty);
        }
        return idProperty;
    }
}

