/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.dsl.mock;

import com.mmnaseri.utils.spring.data.domain.KeyGenerator;
import com.mmnaseri.utils.spring.data.domain.impl.key.BsonObjectIdKeyGenerator;
import com.mmnaseri.utils.spring.data.domain.impl.key.ConfigurableSequentialIntegerKeyGenerator;
import com.mmnaseri.utils.spring.data.domain.impl.key.ConfigurableSequentialLongKeyGenerator;
import com.mmnaseri.utils.spring.data.domain.impl.key.RandomIntegerKeyGenerator;
import com.mmnaseri.utils.spring.data.domain.impl.key.RandomLongKeyGenerator;
import com.mmnaseri.utils.spring.data.domain.impl.key.SequentialIntegerKeyGenerator;
import com.mmnaseri.utils.spring.data.domain.impl.key.SequentialLongKeyGenerator;
import com.mmnaseri.utils.spring.data.domain.impl.key.UUIDKeyGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.core.GenericTypeResolver;
import org.springframework.util.ClassUtils;

class KeyGeneratorProvider {
    private static final String OBJECT_ID_CLASS = "org.bson.types.ObjectId";
    private final Map<Class<?>, List<Class<? extends KeyGenerator>>> generators;

    KeyGeneratorProvider() {
        List<Class<? extends KeyGenerator>> discoveredKeyGenerators = this.getKeyGeneratorTypes();
        this.generators = new ConcurrentHashMap();
        for (Class<? extends KeyGenerator> generatorType : discoveredKeyGenerators) {
            Class keyType = GenericTypeResolver.resolveTypeArgument(generatorType, KeyGenerator.class);
            assert (keyType != null);
            if (!this.generators.containsKey(keyType)) {
                this.generators.put(keyType, new CopyOnWriteArrayList());
            }
            this.generators.get(keyType).add(generatorType);
        }
    }

    private List<Class<? extends KeyGenerator>> getKeyGeneratorTypes() {
        ArrayList<Class<? extends KeyGenerator>> classes = new ArrayList<Class<? extends KeyGenerator>>(Arrays.asList(RandomIntegerKeyGenerator.class, RandomLongKeyGenerator.class, SequentialIntegerKeyGenerator.class, SequentialLongKeyGenerator.class, ConfigurableSequentialIntegerKeyGenerator.class, ConfigurableSequentialLongKeyGenerator.class, UUIDKeyGenerator.class));
        if (ClassUtils.isPresent((String)OBJECT_ID_CLASS, (ClassLoader)ClassUtils.getDefaultClassLoader())) {
            classes.add(BsonObjectIdKeyGenerator.class);
        }
        return classes;
    }

    private <S> List<Class<? extends KeyGenerator<S>>> getKeyGenerators(Class<S> keyType) {
        LinkedList<Class<? extends KeyGenerator<S>>> keyGenerators = new LinkedList<Class<? extends KeyGenerator<S>>>();
        if (this.generators.containsKey(keyType)) {
            this.addKeyGenerators(keyGenerators, keyType);
        }
        for (Class<?> generatorKeyType : this.generators.keySet()) {
            if (!keyType.isAssignableFrom(generatorKeyType)) continue;
            this.addKeyGenerators(keyGenerators, generatorKeyType);
        }
        return keyGenerators;
    }

    private <S> void addKeyGenerators(LinkedList<Class<? extends KeyGenerator<S>>> keyGenerators, Class<?> generatorKeyType) {
        List<Class<? extends KeyGenerator>> classes = this.generators.get(generatorKeyType);
        for (Class<? extends KeyGenerator> type : classes) {
            keyGenerators.add(type);
        }
    }

    public <S> Class<? extends KeyGenerator<S>> getKeyGenerator(Class<S> keyType) {
        List<Class<KeyGenerator<S>>> generators = this.getKeyGenerators(keyType);
        return generators.isEmpty() ? null : generators.get(0);
    }
}

