/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.proxy.impl;

import com.mmnaseri.utils.spring.data.error.UnknownDataOperationException;
import com.mmnaseri.utils.spring.data.proxy.NonDataOperationHandler;
import com.mmnaseri.utils.spring.data.proxy.impl.regular.EqualsNonDataOperationHandler;
import com.mmnaseri.utils.spring.data.proxy.impl.regular.HashCodeNonDataOperationHandler;
import com.mmnaseri.utils.spring.data.proxy.impl.regular.ToStringNonDataOperationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NonDataOperationInvocationHandler
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(NonDataOperationInvocationHandler.class);
    private final List<NonDataOperationHandler> handlers = new LinkedList<NonDataOperationHandler>();

    public NonDataOperationInvocationHandler() {
        this(true);
    }

    public NonDataOperationInvocationHandler(boolean registerDefaults) {
        if (registerDefaults) {
            log.info((Object)"Registering all the default operation handlers");
            this.handlers.add(new EqualsNonDataOperationHandler());
            this.handlers.add(new HashCodeNonDataOperationHandler());
            this.handlers.add(new ToStringNonDataOperationHandler());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        log.info((Object)("Intercepting non-data method " + method));
        for (NonDataOperationHandler handler : this.handlers) {
            if (!handler.handles(proxy, method, args)) continue;
            log.info((Object)("Found handler " + handler + " for method " + method));
            return handler.invoke(proxy, args);
        }
        log.error((Object)("No data or non-data operation handler could be found for method " + method));
        throw new UnknownDataOperationException(method);
    }

    public void register(NonDataOperationHandler handler) {
        log.info((Object)("Registering operation handler " + handler));
        this.handlers.add(handler);
    }

    public List<NonDataOperationHandler> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }
}

