/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.proxy.impl.adapters;

import com.mmnaseri.utils.spring.data.domain.Invocation;
import com.mmnaseri.utils.spring.data.error.ResultAdapterFailureException;
import com.mmnaseri.utils.spring.data.proxy.impl.adapters.AbstractIterableResultAdapter;
import java.util.Iterator;
import java.util.Optional;

public class OptionalResultAdapter
extends AbstractIterableResultAdapter<Object> {
    public OptionalResultAdapter() {
        super(-400);
    }

    @Override
    public boolean accepts(Invocation invocation, Object originalValue) {
        if (!(originalValue instanceof Iterable)) {
            return false;
        }
        Class<Optional> returnType = invocation.getMethod().getReturnType();
        return returnType.isAssignableFrom(Optional.class);
    }

    @Override
    protected Object doAdapt(Invocation invocation, Iterable iterable) {
        Iterator iterator = iterable.iterator();
        if (iterator.hasNext()) {
            Object value = iterator.next();
            if (iterator.hasNext()) {
                throw new ResultAdapterFailureException((Object)iterable, invocation.getMethod().getReturnType(), "Expected only one item but found many");
            }
            return Optional.of(value);
        }
        return Optional.empty();
    }
}

