/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.proxy.impl.resolvers;

import com.mmnaseri.utils.spring.data.domain.RepositoryMetadata;
import com.mmnaseri.utils.spring.data.domain.impl.DescribedDataStoreOperation;
import com.mmnaseri.utils.spring.data.domain.impl.MethodQueryDescriptionExtractor;
import com.mmnaseri.utils.spring.data.domain.impl.SelectDataStoreOperation;
import com.mmnaseri.utils.spring.data.proxy.DataOperationResolver;
import com.mmnaseri.utils.spring.data.proxy.RepositoryFactoryConfiguration;
import com.mmnaseri.utils.spring.data.query.DataFunctionRegistry;
import com.mmnaseri.utils.spring.data.query.QueryDescriptor;
import com.mmnaseri.utils.spring.data.store.DataStoreOperation;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.annotation.QueryAnnotation;

public class QueryMethodDataOperationResolver
implements DataOperationResolver {
    private static final Log log = LogFactory.getLog(QueryMethodDataOperationResolver.class);
    private final MethodQueryDescriptionExtractor descriptionExtractor;
    private final RepositoryMetadata repositoryMetadata;
    private final DataFunctionRegistry functionRegistry;
    private final RepositoryFactoryConfiguration configuration;

    public QueryMethodDataOperationResolver(MethodQueryDescriptionExtractor descriptionExtractor, RepositoryMetadata repositoryMetadata, DataFunctionRegistry functionRegistry, RepositoryFactoryConfiguration configuration) {
        this.descriptionExtractor = descriptionExtractor;
        this.repositoryMetadata = repositoryMetadata;
        this.functionRegistry = functionRegistry;
        this.configuration = configuration;
    }

    @Override
    public DataStoreOperation<?, ?, ?> resolve(Method method) {
        if (AnnotationUtils.findAnnotation((Method)method, QueryAnnotation.class) != null) {
            log.info((Object)("Found a @Query annotation on the method " + method));
            return null;
        }
        log.info((Object)"Extracting query description from the method by parsing the method");
        QueryDescriptor descriptor = this.descriptionExtractor.extract(this.repositoryMetadata, this.configuration, method);
        return new DescribedDataStoreOperation(new SelectDataStoreOperation(descriptor), this.functionRegistry);
    }
}

