/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.query.impl;

import com.mmnaseri.utils.spring.data.domain.Invocation;
import com.mmnaseri.utils.spring.data.error.InvalidArgumentException;
import com.mmnaseri.utils.spring.data.query.Sort;
import com.mmnaseri.utils.spring.data.query.impl.AbstractSortParameterExtractor;
import org.springframework.data.domain.Pageable;

public class PageableSortParameterExtractor
extends AbstractSortParameterExtractor {
    private final int index;

    public PageableSortParameterExtractor(int index) {
        this.index = index;
    }

    @Override
    public Sort extract(Invocation invocation) {
        if (invocation == null) {
            throw new InvalidArgumentException("Invocation cannot be null");
        }
        Object value = invocation.getArguments()[this.index];
        if (value == null) {
            throw new InvalidArgumentException("Page value should not be empty");
        }
        if (value instanceof Pageable) {
            Pageable pageable = (Pageable)value;
            org.springframework.data.domain.Sort sort = pageable.getSort();
            return this.getSort(sort);
        }
        throw new InvalidArgumentException("No valid value was passed to deduce the sort description from");
    }
}

