/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.repository;

import com.mmnaseri.utils.spring.data.domain.Modifier;
import com.mmnaseri.utils.spring.data.domain.Operator;
import com.mmnaseri.utils.spring.data.domain.OperatorContext;
import com.mmnaseri.utils.spring.data.domain.RepositoryMetadata;
import com.mmnaseri.utils.spring.data.domain.impl.ImmutableParameter;
import com.mmnaseri.utils.spring.data.domain.impl.QueryDescriptionExtractor;
import com.mmnaseri.utils.spring.data.proxy.RepositoryFactoryConfiguration;
import com.mmnaseri.utils.spring.data.query.QueryDescriptor;
import com.mmnaseri.utils.spring.data.query.impl.DefaultQueryDescriptor;
import com.mmnaseri.utils.spring.data.tools.PropertyUtils;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;

public class ExampleMatcherQueryDescriptionExtractor
implements QueryDescriptionExtractor<Example> {
    @Override
    public QueryDescriptor extract(RepositoryMetadata repositoryMetadata, RepositoryFactoryConfiguration configuration, Example example) {
        OperatorContext operatorContext = configuration.getDescriptionExtractor().getOperatorContext();
        Map<String, Object> values = this.extractValues(example.getProbe());
        ExampleMatcher matcher = example.getMatcher();
        ArrayList<ImmutableParameter> parameters = new ArrayList<ImmutableParameter>();
        int index = 0;
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            Operator operator;
            String propertyPath = entry.getKey();
            if (matcher.isIgnoredPath(propertyPath)) continue;
            HashSet<Modifier> modifiers = new HashSet<Modifier>();
            if (entry.getValue() == null) {
                if (ExampleMatcher.NullHandler.IGNORE.equals((Object)matcher.getNullHandler())) continue;
                operator = operatorContext.getBySuffix("IsNull");
            } else {
                ExampleMatcher.StringMatcher stringMatcher;
                if (this.ignoreCase(matcher, propertyPath)) {
                    modifiers.add(Modifier.IGNORE_CASE);
                }
                operator = ExampleMatcher.StringMatcher.STARTING.equals((Object)(stringMatcher = this.stringMatcher(matcher, propertyPath))) ? operatorContext.getBySuffix("StartsWith") : (ExampleMatcher.StringMatcher.ENDING.equals((Object)stringMatcher) ? operatorContext.getBySuffix("EndsWith") : (ExampleMatcher.StringMatcher.CONTAINING.equals((Object)stringMatcher) ? operatorContext.getBySuffix("Contains") : (ExampleMatcher.StringMatcher.REGEX.equals((Object)stringMatcher) ? operatorContext.getBySuffix("Matches") : operatorContext.getBySuffix("Is"))));
            }
            parameters.add(new ImmutableParameter(propertyPath, modifiers, new int[]{index++}, operator));
        }
        return new DefaultQueryDescriptor(false, null, 0, null, null, Collections.singletonList(parameters), configuration, repositoryMetadata);
    }

    private ExampleMatcher.StringMatcher stringMatcher(ExampleMatcher matcher, String path) {
        ExampleMatcher.PropertySpecifier specifier = matcher.getPropertySpecifiers().getForPath(path);
        return specifier != null ? specifier.getStringMatcher() : matcher.getDefaultStringMatcher();
    }

    private boolean ignoreCase(ExampleMatcher matcher, String path) {
        ExampleMatcher.PropertySpecifier specifier = matcher.getPropertySpecifiers().getForPath(path);
        return matcher.isIgnoreCaseEnabled() || specifier != null && Boolean.TRUE.equals(specifier.getIgnoreCase());
    }

    private Map<String, Object> extractValues(Object object) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        BeanWrapperImpl wrapper = new BeanWrapperImpl(object);
        for (PropertyDescriptor descriptor : wrapper.getPropertyDescriptors()) {
            if (descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null) continue;
            String propertyName = descriptor.getName();
            Object value = PropertyUtils.getPropertyValue(object, propertyName);
            if (value == null) {
                result.put(propertyName, null);
                continue;
            }
            if (this.isIntractable(descriptor, value)) {
                result.put(propertyName, value);
                continue;
            }
            Map<String, Object> children = this.extractValues(value);
            for (Map.Entry<String, Object> entry : children.entrySet()) {
                result.put(propertyName + "." + entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private boolean isIntractable(PropertyDescriptor descriptor, Object value) {
        Class<?> type = descriptor.getPropertyType();
        return type.isPrimitive() || type.getName().startsWith("java.lang.") || value instanceof Iterable || value instanceof Map;
    }
}

