/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.repository;

import com.mmnaseri.utils.spring.data.domain.impl.PropertyComparator;
import com.mmnaseri.utils.spring.data.query.NullHandling;
import com.mmnaseri.utils.spring.data.query.Order;
import com.mmnaseri.utils.spring.data.query.SortDirection;
import com.mmnaseri.utils.spring.data.query.impl.ImmutableOrder;
import com.mmnaseri.utils.spring.data.query.impl.ImmutableSort;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

final class PagingAndSortingUtils {
    private static final Log log = LogFactory.getLog(PagingAndSortingUtils.class);

    private PagingAndSortingUtils() {
        throw new UnsupportedOperationException();
    }

    public static List sort(Collection entries, Sort sort) {
        LinkedList list = new LinkedList(entries);
        if (sort == null) {
            log.info((Object)"No sort was specified, so we are just going to return the data as-is");
            return list;
        }
        LinkedList<Order> orders = new LinkedList<Order>();
        for (Sort.Order order : sort) {
            NullHandling nullHandling;
            SortDirection direction = order.getDirection().equals((Object)Sort.Direction.ASC) ? SortDirection.ASCENDING : SortDirection.DESCENDING;
            switch (order.getNullHandling()) {
                case NULLS_FIRST: {
                    nullHandling = NullHandling.NULLS_FIRST;
                    break;
                }
                case NULLS_LAST: {
                    nullHandling = NullHandling.NULLS_LAST;
                    break;
                }
                default: {
                    nullHandling = NullHandling.DEFAULT;
                }
            }
            ImmutableOrder derivedOrder = new ImmutableOrder(direction, order.getProperty(), nullHandling);
            orders.add(derivedOrder);
        }
        log.info((Object)("Sorting the retrieved data: " + orders));
        PropertyComparator.sort(list, new ImmutableSort(orders));
        return list;
    }

    public static Page page(Collection entries, Pageable pageable) {
        LinkedList all;
        if (pageable.getSort().isSorted()) {
            log.info((Object)"The page specification requests sorting, so we are going to sort the data first");
            all = PagingAndSortingUtils.sort(entries, pageable.getSort());
        } else {
            log.info((Object)"The page specification does not need sorting, so we are going to load the data as-is");
            all = new LinkedList(entries);
        }
        int start = Math.max(0, pageable.getPageNumber() * pageable.getPageSize());
        int end = start + pageable.getPageSize();
        start = Math.min(start, all.size());
        end = Math.min(end, all.size());
        log.info((Object)("Trimming the selection down for page " + pageable.getPageNumber() + " to include items from " + start + " to " + end));
        LinkedList selection = new LinkedList(all.subList(start, end));
        return new PageImpl(selection, pageable, (long)all.size());
    }
}

