/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.store.impl;

import com.mmnaseri.utils.spring.data.domain.RepositoryMetadata;
import com.mmnaseri.utils.spring.data.store.impl.PropertyVisitor;
import com.mmnaseri.utils.spring.data.tools.GetterMethodFilter;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.domain.Auditable;
import org.springframework.util.ReflectionUtils;

public class AuditableWrapper
implements Auditable {
    private final BeanWrapper wrapper;
    private final RepositoryMetadata repositoryMetadata;
    private final String createdBy;
    private final String createdDate;
    private final String lastModifiedBy;
    private final String lastModifiedDate;

    public AuditableWrapper(Object entity, RepositoryMetadata repositoryMetadata) {
        this.repositoryMetadata = repositoryMetadata;
        this.wrapper = new BeanWrapperImpl(entity);
        this.createdBy = AuditableWrapper.findProperty(repositoryMetadata.getEntityType(), CreatedBy.class);
        this.createdDate = AuditableWrapper.findProperty(repositoryMetadata.getEntityType(), CreatedDate.class);
        this.lastModifiedBy = AuditableWrapper.findProperty(repositoryMetadata.getEntityType(), LastModifiedBy.class);
        this.lastModifiedDate = AuditableWrapper.findProperty(repositoryMetadata.getEntityType(), LastModifiedDate.class);
    }

    @Nonnull
    public Optional<Object> getCreatedBy() {
        return Optional.ofNullable(AuditableWrapper.getProperty(Object.class, this.wrapper, this.createdBy));
    }

    public void setCreatedBy(@Nonnull Object createdBy) {
        AuditableWrapper.setProperty(this.wrapper, this.createdBy, createdBy);
    }

    @Nonnull
    public Optional<Instant> getCreatedDate() {
        return Optional.ofNullable(AuditableWrapper.getProperty(Instant.class, this.wrapper, this.createdDate));
    }

    public void setCreatedDate(@Nonnull TemporalAccessor creationDate) {
        AuditableWrapper.setProperty(this.wrapper, this.createdDate, creationDate);
    }

    @Nonnull
    public Optional<Object> getLastModifiedBy() {
        return Optional.ofNullable(AuditableWrapper.getProperty(Object.class, this.wrapper, this.lastModifiedBy));
    }

    public void setLastModifiedBy(@Nonnull Object lastModifiedBy) {
        AuditableWrapper.setProperty(this.wrapper, this.lastModifiedBy, lastModifiedBy);
    }

    @Nonnull
    public Optional<Instant> getLastModifiedDate() {
        return Optional.ofNullable(AuditableWrapper.getProperty(Instant.class, this.wrapper, this.lastModifiedDate));
    }

    public void setLastModifiedDate(@Nonnull TemporalAccessor lastModifiedDate) {
        AuditableWrapper.setProperty(this.wrapper, this.lastModifiedDate, lastModifiedDate);
    }

    public Object getId() {
        return this.wrapper.getPropertyValue(this.repositoryMetadata.getIdentifierProperty());
    }

    public boolean isNew() {
        return this.getId() == null;
    }

    private static String findProperty(Class<?> entityType, Class<? extends Annotation> annotationType) {
        PropertyVisitor visitor = new PropertyVisitor(annotationType);
        ReflectionUtils.doWithFields(entityType, (ReflectionUtils.FieldCallback)visitor);
        ReflectionUtils.doWithMethods(entityType, (ReflectionUtils.MethodCallback)visitor, (ReflectionUtils.MethodFilter)new GetterMethodFilter());
        return visitor.getProperty();
    }

    private static <E> E getProperty(Class<E> type, BeanWrapper wrapper, String property) {
        if (property == null || !wrapper.isReadableProperty(property)) {
            return null;
        }
        Object propertyValue = wrapper.getPropertyValue(property);
        if (propertyValue instanceof java.util.Date) {
            propertyValue = Instant.ofEpochMilli(((java.util.Date)propertyValue).getTime());
        }
        return type.cast(propertyValue);
    }

    private static void setProperty(BeanWrapper wrapper, String property, Object value) {
        if (property != null) {
            Object targetValue = value;
            PropertyDescriptor descriptor = wrapper.getPropertyDescriptor(property);
            if (targetValue instanceof Instant) {
                Instant instant = (Instant)targetValue;
                if (java.util.Date.class.equals(descriptor.getPropertyType())) {
                    targetValue = new java.util.Date(instant.toEpochMilli());
                } else if (Date.class.equals(descriptor.getPropertyType())) {
                    targetValue = new Date(instant.toEpochMilli());
                } else if (Timestamp.class.equals(descriptor.getPropertyType())) {
                    targetValue = new Timestamp(instant.toEpochMilli());
                } else if (Time.class.equals(descriptor.getPropertyType())) {
                    targetValue = new Time(instant.toEpochMilli());
                }
            }
            if (wrapper.isWritableProperty(property)) {
                wrapper.setPropertyValue(property, targetValue);
            }
        }
    }
}

