/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.store.impl;

import com.mmnaseri.utils.spring.data.domain.RepositoryMetadata;
import com.mmnaseri.utils.spring.data.error.CorruptDataException;
import com.mmnaseri.utils.spring.data.store.DataStore;
import com.mmnaseri.utils.spring.data.store.DataStoreEvent;
import com.mmnaseri.utils.spring.data.store.DataStoreEventListenerContext;
import com.mmnaseri.utils.spring.data.store.DataStoreEventPublisher;
import com.mmnaseri.utils.spring.data.store.impl.AfterDeleteDataStoreEvent;
import com.mmnaseri.utils.spring.data.store.impl.AfterInsertDataStoreEvent;
import com.mmnaseri.utils.spring.data.store.impl.AfterUpdateDataStoreEvent;
import com.mmnaseri.utils.spring.data.store.impl.BeforeDeleteDataStoreEvent;
import com.mmnaseri.utils.spring.data.store.impl.BeforeInsertDataStoreEvent;
import com.mmnaseri.utils.spring.data.store.impl.BeforeUpdateDataStoreEvent;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventPublishingDataStore<K, E>
implements DataStore<K, E>,
DataStoreEventPublisher {
    private static final Log log = LogFactory.getLog(EventPublishingDataStore.class);
    private final DataStore<K, E> delegate;
    private final RepositoryMetadata repositoryMetadata;
    private final DataStoreEventListenerContext listenerContext;

    public EventPublishingDataStore(DataStore<K, E> delegate, RepositoryMetadata repositoryMetadata, DataStoreEventListenerContext listenerContext) {
        this.delegate = delegate;
        this.repositoryMetadata = repositoryMetadata;
        this.listenerContext = listenerContext;
    }

    @Override
    public boolean hasKey(K key) {
        return this.delegate.hasKey(key);
    }

    @Override
    public boolean save(K key, E entity) {
        boolean entityIsNew;
        if (key == null) {
            log.error((Object)"Cannot save an entity under a null key");
            throw new CorruptDataException(this.getEntityType(), null, "Cannot save an entity with a null key");
        }
        if (entity == null) {
            log.error((Object)"Cannot save a null value into the data store");
            throw new CorruptDataException(this.getEntityType(), null, "Cannot save null into the data store");
        }
        boolean bl = entityIsNew = !this.delegate.hasKey(key);
        if (entityIsNew) {
            log.info((Object)("About to insert a new entity in the data store under key " + key));
            this.publishEvent(new BeforeInsertDataStoreEvent(this.repositoryMetadata, this, entity));
        } else {
            log.info((Object)("About to update the entity in the data store under key " + key));
            this.publishEvent(new BeforeUpdateDataStoreEvent(this.repositoryMetadata, this, entity));
        }
        this.delegate.save(key, entity);
        if (entityIsNew) {
            log.info((Object)("Finished inserting the entity in the data store under key " + key));
            this.publishEvent(new AfterInsertDataStoreEvent(this.repositoryMetadata, this, entity));
            return true;
        }
        log.info((Object)("Finished updating the entity under key " + key));
        this.publishEvent(new AfterUpdateDataStoreEvent(this.repositoryMetadata, this, entity));
        return false;
    }

    @Override
    public boolean delete(K key) {
        if (!this.delegate.hasKey(key)) {
            log.info((Object)("Attempted to delete entity with key " + key + " but found nothing"));
            return false;
        }
        E entity = this.delegate.retrieve(key);
        log.info((Object)("About to delete an entity with key " + key));
        this.publishEvent(new BeforeDeleteDataStoreEvent(this.repositoryMetadata, this, entity));
        this.delegate.delete(key);
        log.info((Object)("Finished deleting the entity with key " + key));
        this.publishEvent(new AfterDeleteDataStoreEvent(this.repositoryMetadata, this, entity));
        return true;
    }

    @Override
    public E retrieve(K key) {
        return this.delegate.retrieve(key);
    }

    @Override
    public Collection<K> keys() {
        return this.delegate.keys();
    }

    @Override
    public Collection<E> retrieveAll() {
        return this.delegate.retrieveAll();
    }

    @Override
    public Class<E> getEntityType() {
        return this.delegate.getEntityType();
    }

    @Override
    public void truncate() {
        this.delegate.truncate();
    }

    @Override
    public void publishEvent(DataStoreEvent event) {
        this.listenerContext.trigger(event);
    }
}

