/*
 * Decompiled with CFR 0.152.
 */
package com.mmnaseri.utils.spring.data.store.impl;

import com.mmnaseri.utils.spring.data.store.DataStoreEvent;
import com.mmnaseri.utils.spring.data.store.DataStoreEventListener;
import org.springframework.core.GenericTypeResolver;

public class SmartDataStoreEventListener<E extends DataStoreEvent>
implements DataStoreEventListener<E> {
    private final DataStoreEventListener<E> delegate;
    private final Class<E> eventType;

    public SmartDataStoreEventListener(DataStoreEventListener<E> delegate) {
        this.delegate = delegate;
        this.eventType = GenericTypeResolver.resolveTypeArgument(delegate.getClass(), DataStoreEventListener.class);
    }

    @Override
    public void onEvent(E event) {
        this.delegate.onEvent(event);
    }

    public Class<E> getEventType() {
        return this.eventType;
    }

    public DataStoreEventListener<E> getDelegate() {
        return this.delegate;
    }
}

