/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator;

import com.moilioncircle.redis.replicator.RedisURI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;

public class Configuration {
    private int connectionTimeout = 30000;
    private int readTimeout = 30000;
    private int receiveBufferSize = 0;
    private int sendBufferSize = 0;
    private int retries = 5;
    private int retryTimeInterval = 1000;
    private int bufferSize = 8192;
    private String authPassword = null;
    private boolean discardRdbEvent = false;
    private int asyncCachedBytes = 524288;
    private int rateLimit = 0;
    private boolean verbose = false;
    private int heartBeatPeriod = 1000;
    private boolean useDefaultExceptionListener = true;
    private boolean ssl = false;
    private SSLSocketFactory sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    private SSLParameters sslParameters;
    private HostnameVerifier hostnameVerifier;
    private String replId = "?";
    private final AtomicLong replOffset = new AtomicLong(-1L);

    private Configuration() {
    }

    public static Configuration defaultSetting() {
        return new Configuration();
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Configuration setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public Configuration setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public int getRetries() {
        return this.retries;
    }

    public Configuration setRetries(int retries) {
        this.retries = retries;
        return this;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public Configuration setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
        return this;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public Configuration setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
        return this;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public Configuration setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
        return this;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public Configuration setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public boolean isDiscardRdbEvent() {
        return this.discardRdbEvent;
    }

    public Configuration setDiscardRdbEvent(boolean discardRdbEvent) {
        this.discardRdbEvent = discardRdbEvent;
        return this;
    }

    public String getReplId() {
        return this.replId;
    }

    public Configuration setReplId(String replId) {
        this.replId = replId;
        return this;
    }

    public long getReplOffset() {
        return this.replOffset.get();
    }

    public Configuration setReplOffset(long replOffset) {
        this.replOffset.set(replOffset);
        return this;
    }

    public Configuration addOffset(long offset) {
        this.replOffset.addAndGet(offset);
        return this;
    }

    public int getAsyncCachedBytes() {
        return this.asyncCachedBytes;
    }

    public Configuration setAsyncCachedBytes(int asyncCachedBytes) {
        this.asyncCachedBytes = asyncCachedBytes;
        return this;
    }

    public int getRateLimit() {
        return this.rateLimit;
    }

    public Configuration setRateLimit(int rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Configuration setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public int getHeartBeatPeriod() {
        return this.heartBeatPeriod;
    }

    public Configuration setHeartBeatPeriod(int heartBeatPeriod) {
        this.heartBeatPeriod = heartBeatPeriod;
        return this;
    }

    public boolean isUseDefaultExceptionListener() {
        return this.useDefaultExceptionListener;
    }

    public Configuration setUseDefaultExceptionListener(boolean useDefaultExceptionListener) {
        this.useDefaultExceptionListener = useDefaultExceptionListener;
        return this;
    }

    public int getRetryTimeInterval() {
        return this.retryTimeInterval;
    }

    public Configuration setRetryTimeInterval(int retryTimeInterval) {
        this.retryTimeInterval = retryTimeInterval;
        return this;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public Configuration setSsl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public Configuration setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public SSLParameters getSslParameters() {
        return this.sslParameters;
    }

    public Configuration setSslParameters(SSLParameters sslParameters) {
        this.sslParameters = sslParameters;
        return this;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public Configuration setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public static Configuration valueOf(RedisURI uri) {
        Configuration configuration = Configuration.defaultSetting();
        Map<String, String> parameters = uri.parameters;
        if (parameters.containsKey("connectionTimeout")) {
            configuration.setConnectionTimeout(Configuration.getInt(parameters.get("connectionTimeout")));
        }
        if (parameters.containsKey("readTimeout")) {
            configuration.setReadTimeout(Configuration.getInt(parameters.get("readTimeout")));
        }
        if (parameters.containsKey("receiveBufferSize")) {
            configuration.setReceiveBufferSize(Configuration.getInt(parameters.get("receiveBufferSize")));
        }
        if (parameters.containsKey("sendBufferSize")) {
            configuration.setSendBufferSize(Configuration.getInt(parameters.get("sendBufferSize")));
        }
        if (parameters.containsKey("retries")) {
            configuration.setRetries(Configuration.getInt(parameters.get("retries")));
        }
        if (parameters.containsKey("retryTimeInterval")) {
            configuration.setRetryTimeInterval(Configuration.getInt(parameters.get("retryTimeInterval")));
        }
        if (parameters.containsKey("bufferSize")) {
            configuration.setBufferSize(Configuration.getInt(parameters.get("bufferSize")));
        }
        if (parameters.containsKey("authPassword")) {
            configuration.setAuthPassword(parameters.get("authPassword"));
        }
        if (parameters.containsKey("discardRdbEvent")) {
            configuration.setDiscardRdbEvent(Configuration.getBool(parameters.get("discardRdbEvent")));
        }
        if (parameters.containsKey("asyncCachedBytes")) {
            configuration.setAsyncCachedBytes(Configuration.getInt(parameters.get("asyncCachedBytes")));
        }
        if (parameters.containsKey("rateLimit")) {
            configuration.setRateLimit(Configuration.getInt(parameters.get("rateLimit")));
        }
        if (parameters.containsKey("verbose")) {
            configuration.setVerbose(Configuration.getBool(parameters.get("verbose")));
        }
        if (parameters.containsKey("heartBeatPeriod")) {
            configuration.setHeartBeatPeriod(Configuration.getInt(parameters.get("heartBeatPeriod")));
        }
        if (parameters.containsKey("useDefaultExceptionListener")) {
            configuration.setUseDefaultExceptionListener(Configuration.getBool(parameters.get("useDefaultExceptionListener")));
        }
        if (parameters.containsKey("ssl")) {
            configuration.setSsl(Configuration.getBool(parameters.get("ssl")));
        }
        if (parameters.containsKey("replId")) {
            configuration.setReplId(parameters.get("replId"));
        }
        if (parameters.containsKey("replOffset")) {
            configuration.setReplOffset(Configuration.getLong(parameters.get("replOffset")));
        }
        return configuration;
    }

    private static boolean getBool(String value) {
        if (value == null) {
            return false;
        }
        if (value.equals("false") || value.equals("no")) {
            return false;
        }
        return value.equals("true") || value.equals("yes");
    }

    private static int getInt(String value) {
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static long getLong(String value) {
        if (value == null) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public String toString() {
        return "Configuration{connectionTimeout=" + this.connectionTimeout + ", readTimeout=" + this.readTimeout + ", receiveBufferSize=" + this.receiveBufferSize + ", sendBufferSize=" + this.sendBufferSize + ", retries=" + this.retries + ", retryTimeInterval=" + this.retryTimeInterval + ", bufferSize=" + this.bufferSize + ", authPassword='" + this.authPassword + '\'' + ", discardRdbEvent=" + this.discardRdbEvent + ", asyncCachedBytes=" + this.asyncCachedBytes + ", rateLimit=" + this.rateLimit + ", verbose=" + this.verbose + ", heartBeatPeriod=" + this.heartBeatPeriod + ", useDefaultExceptionListener=" + this.useDefaultExceptionListener + ", ssl=" + this.ssl + ", sslSocketFactory=" + this.sslSocketFactory + ", sslParameters=" + this.sslParameters + ", hostnameVerifier=" + this.hostnameVerifier + ", replId='" + this.replId + '\'' + ", replOffset=" + this.replOffset + '}';
    }
}

