/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator;

import com.moilioncircle.redis.replicator.AbstractReplicator;
import com.moilioncircle.redis.replicator.Configuration;
import com.moilioncircle.redis.replicator.DefaultExceptionListener;
import com.moilioncircle.redis.replicator.UncheckedIOException;
import com.moilioncircle.redis.replicator.cmd.CommandName;
import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.ReplyParser;
import com.moilioncircle.redis.replicator.event.Event;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.util.Arrays;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RedisAofReplicator
extends AbstractReplicator {
    protected static final Log logger = LogFactory.getLog(RedisAofReplicator.class);
    protected final ReplyParser replyParser;

    public RedisAofReplicator(File file, Configuration configuration) throws FileNotFoundException {
        this(new FileInputStream(file), configuration);
    }

    public RedisAofReplicator(InputStream in, Configuration configuration) {
        Objects.requireNonNull(in);
        Objects.requireNonNull(configuration);
        this.configuration = configuration;
        this.inputStream = new RedisInputStream(in, this.configuration.getBufferSize());
        this.inputStream.setRawByteListeners(this.rawByteListeners);
        this.replyParser = new ReplyParser(this.inputStream);
        this.builtInCommandParserRegister();
        if (configuration.isUseDefaultExceptionListener()) {
            this.addExceptionListener(new DefaultExceptionListener());
        }
    }

    @Override
    public void open() throws IOException {
        try {
            this.doOpen();
        }
        catch (EOFException eOFException) {
        }
        catch (UncheckedIOException e) {
            if (!(e.getCause() instanceof EOFException)) {
                throw e;
            }
        }
        finally {
            this.close();
        }
    }

    protected void doOpen() throws IOException {
        while (true) {
            Object obj;
            if ((obj = this.replyParser.parse()) instanceof Object[]) {
                Object[] command;
                CommandName cmdName;
                CommandParser operations;
                if (this.configuration.isVerbose() && logger.isDebugEnabled()) {
                    logger.debug((Object)Arrays.deepToString((Object[])obj));
                }
                if ((operations = (CommandParser)this.commands.get(cmdName = CommandName.name(new String((byte[])(command = (Object[])obj)[0], StandardCharsets.UTF_8)))) == null) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn((Object)("command [" + cmdName + "] not register. raw command:[" + Arrays.deepToString(command) + "]"));
                    continue;
                }
                Object parsedCommand = operations.parse(command);
                this.submitEvent((Event)parsedCommand);
                continue;
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("redis reply:" + obj));
        }
    }

    @Override
    public void close() throws IOException {
        this.doClose();
    }
}

