/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator;

import com.moilioncircle.redis.replicator.AbstractReplicator;
import com.moilioncircle.redis.replicator.Configuration;
import com.moilioncircle.redis.replicator.DefaultExceptionListener;
import com.moilioncircle.redis.replicator.UncheckedIOException;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.RdbParser;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class RedisRdbReplicator
extends AbstractReplicator {
    public RedisRdbReplicator(File file, Configuration configuration) throws FileNotFoundException {
        this(new FileInputStream(file), configuration);
    }

    public RedisRdbReplicator(InputStream in, Configuration configuration) {
        Objects.requireNonNull(in);
        Objects.requireNonNull(configuration);
        this.configuration = configuration;
        this.inputStream = new RedisInputStream(in, this.configuration.getBufferSize());
        this.inputStream.setRawByteListeners(this.rawByteListeners);
        if (configuration.isUseDefaultExceptionListener()) {
            this.addExceptionListener(new DefaultExceptionListener());
        }
    }

    @Override
    public void open() throws IOException {
        try {
            this.doOpen();
        }
        catch (EOFException eOFException) {
        }
        catch (UncheckedIOException e) {
            if (!(e.getCause() instanceof EOFException)) {
                throw e;
            }
        }
        finally {
            this.close();
        }
    }

    protected void doOpen() throws IOException {
        RdbParser parser = new RdbParser(this.inputStream, this);
        parser.parse();
    }

    @Override
    public void close() throws IOException {
        this.doClose();
    }
}

