/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator;

import com.moilioncircle.redis.replicator.FileType;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import sun.nio.cs.ThreadLocalCoders;

public final class RedisURI
implements Comparable<RedisURI> {
    private String host;
    private String path;
    private String query;
    private int port = -1;
    private String scheme;
    private String userInfo;
    private String fragment;
    private String authority;
    private FileType fileType;
    private URI uri;
    Map<String, String> parameters = new HashMap<String, String>();

    public RedisURI(String uri) throws URISyntaxException {
        this.parse(uri);
    }

    private void parse(String uri) throws URISyntaxException {
        String rawQuery;
        int idx;
        this.uri = new URI(uri);
        if (!this.uri.getScheme().equalsIgnoreCase("redis")) {
            throw new IllegalArgumentException("scheme must be [redis].");
        }
        this.scheme = "redis";
        this.host = this.uri.getHost();
        this.path = this.uri.getPath();
        this.query = this.uri.getQuery();
        this.port = this.uri.getPort() == -1 ? 6379 : this.uri.getPort();
        this.userInfo = this.uri.getUserInfo();
        this.fragment = this.uri.getFragment();
        this.authority = this.uri.getAuthority();
        if (this.path != null && this.userInfo == null && (idx = this.path.lastIndexOf(46)) >= 0) {
            String type = this.path.substring(idx + 1);
            this.fileType = FileType.parse(type);
        }
        if ((rawQuery = this.uri.getRawQuery()) == null) {
            return;
        }
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        StringBuilder sb = key;
        block4: for (char c : rawQuery.toCharArray()) {
            switch (c) {
                case '&': 
                case ';': {
                    if (key.length() > 0 && value.length() > 0) {
                        this.parameters.put(RedisURI.decode(key.toString()), RedisURI.decode(value.toString()));
                    }
                    key.setLength(0);
                    value.setLength(0);
                    sb = key;
                    continue block4;
                }
                case '=': {
                    sb = value;
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (key.length() > 0 && value.length() > 0) {
            this.parameters.put(RedisURI.decode(key.toString()), RedisURI.decode(value.toString()));
        }
    }

    private static String decode(String s) {
        if (s == null) {
            return null;
        }
        int n = s.length();
        if (n == 0) {
            return s;
        }
        if (s.indexOf(37) < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(n);
        ByteBuffer bb = ByteBuffer.allocate(n);
        CharBuffer cb = CharBuffer.allocate(n);
        CharsetDecoder dec = ThreadLocalCoders.decoderFor("UTF-8").onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        char c = s.charAt(0);
        boolean betweenBrackets = false;
        int i = 0;
        while (i < n) {
            assert (c == s.charAt(i));
            if (c == '[') {
                betweenBrackets = true;
            } else if (betweenBrackets && c == ']') {
                betweenBrackets = false;
            }
            if (c != '%' || betweenBrackets) {
                sb.append(c);
                if (++i >= n) break;
                c = s.charAt(i);
                continue;
            }
            bb.clear();
            do {
                bb.put(RedisURI.decode(s.charAt(++i), s.charAt(++i)));
            } while (++i < n && (c = s.charAt(i)) == '%');
            bb.flip();
            cb.clear();
            dec.reset();
            CoderResult cr = dec.decode(bb, cb, true);
            assert (cr.isUnderflow());
            cr = dec.flush(cb);
            assert (cr.isUnderflow());
            sb.append(cb.flip().toString());
        }
        return sb.toString();
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    private static byte decode(char c1, char c2) {
        return (byte)((RedisURI.decode(c1) & 0xF) << 4 | (RedisURI.decode(c2) & 0xF) << 0);
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getAuthority() {
        return this.authority;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RedisURI)) {
            return false;
        }
        return this.uri.equals(((RedisURI)o).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    @Override
    public int compareTo(RedisURI that) {
        return this.uri.compareTo(that.uri);
    }

    public URL toURL() throws MalformedURLException {
        Objects.requireNonNull(this.getFileType());
        try {
            return new URI("file", this.uri.getRawAuthority(), this.uri.getRawPath(), this.uri.getRawQuery(), this.uri.getRawFragment()).toURL();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    public String toString() {
        return this.uri.toString();
    }
}

