/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.impl.BitFieldCommand;
import com.moilioncircle.redis.replicator.cmd.impl.GetTypeOffset;
import com.moilioncircle.redis.replicator.cmd.impl.IncrByTypeOffsetIncrement;
import com.moilioncircle.redis.replicator.cmd.impl.OverFlow;
import com.moilioncircle.redis.replicator.cmd.impl.OverFlowType;
import com.moilioncircle.redis.replicator.cmd.impl.SetTypeOffsetValue;
import com.moilioncircle.redis.replicator.cmd.impl.Statement;
import com.moilioncircle.redis.replicator.cmd.parser.CommandParsers;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class BitFieldParser
implements CommandParser<BitFieldCommand> {
    @Override
    public BitFieldCommand parse(Object[] command) {
        int idx = 1;
        String key = CommandParsers.objToString(command[idx]);
        byte[] rawKey = CommandParsers.objToBytes(command[idx]);
        ArrayList<Statement> list = new ArrayList<Statement>();
        if (++idx < command.length) {
            String token;
            while ((idx = this.parseStatement(idx, command, list)) < command.length && (token = CommandParsers.objToString(command[idx])) != null && (token.equalsIgnoreCase("GET") || token.equalsIgnoreCase("SET") || token.equalsIgnoreCase("INCRBY"))) {
            }
        }
        ArrayList<OverFlow> overFlowList = null;
        if (idx < command.length) {
            overFlowList = new ArrayList<OverFlow>();
            do {
                OverFlow overFlow = new OverFlow();
                idx = this.parseOverFlow(idx, command, overFlow);
                overFlowList.add(overFlow);
            } while (idx < command.length && "OVERFLOW".equalsIgnoreCase(CommandParsers.objToString(command[idx])));
        }
        return new BitFieldCommand(key, list, overFlowList, rawKey);
    }

    private int parseOverFlow(int i, Object[] params, OverFlow overFlow) {
        OverFlowType overFlowType;
        int idx = i;
        this.accept(CommandParsers.objToString(params[idx++]), "OVERFLOW");
        String keyWord = CommandParsers.objToString(params[idx++]);
        if ("WRAP".equalsIgnoreCase(keyWord)) {
            overFlowType = OverFlowType.WRAP;
        } else if ("SAT".equalsIgnoreCase(keyWord)) {
            overFlowType = OverFlowType.SAT;
        } else if ("FAIL".equalsIgnoreCase(keyWord)) {
            overFlowType = OverFlowType.FAIL;
        } else {
            throw new AssertionError((Object)("parse [BITFIELD] command error." + keyWord));
        }
        ArrayList<Statement> list = new ArrayList<Statement>();
        if (idx < params.length) {
            String token;
            while ((idx = this.parseStatement(idx, params, list)) < params.length && (token = CommandParsers.objToString(params[idx])) != null && (token.equalsIgnoreCase("GET") || token.equalsIgnoreCase("SET") || token.equalsIgnoreCase("INCRBY"))) {
            }
        }
        overFlow.setOverFlowType(overFlowType);
        overFlow.setStatements(list);
        return idx;
    }

    private int parseStatement(int i, Object[] params, List<Statement> list) {
        Statement statement;
        String keyWord;
        int idx = i;
        if ("GET".equalsIgnoreCase(keyWord = CommandParsers.objToString(params[idx++]))) {
            GetTypeOffset getTypeOffset = new GetTypeOffset();
            idx = this.parseGet(idx - 1, params, getTypeOffset);
            statement = getTypeOffset;
        } else if ("SET".equalsIgnoreCase(keyWord)) {
            SetTypeOffsetValue setTypeOffsetValue = new SetTypeOffsetValue();
            idx = this.parseSet(idx - 1, params, setTypeOffsetValue);
            statement = setTypeOffsetValue;
        } else if ("INCRBY".equalsIgnoreCase(keyWord)) {
            IncrByTypeOffsetIncrement incrByTypeOffsetIncrement = new IncrByTypeOffsetIncrement();
            idx = this.parseIncrBy(idx - 1, params, incrByTypeOffsetIncrement);
            statement = incrByTypeOffsetIncrement;
        } else {
            return i;
        }
        list.add(statement);
        return idx;
    }

    private int parseIncrBy(int i, Object[] params, IncrByTypeOffsetIncrement incrByTypeOffsetIncrement) {
        int idx = i;
        this.accept(CommandParsers.objToString(params[idx++]), "INCRBY");
        String type = CommandParsers.objToString(params[idx]);
        byte[] rawType = CommandParsers.objToBytes(params[idx]);
        String offset = CommandParsers.objToString(params[++idx]);
        byte[] rawOffset = CommandParsers.objToBytes(params[idx]);
        int n = ++idx;
        ++idx;
        long increment = new BigDecimal(CommandParsers.objToString(params[n])).longValueExact();
        incrByTypeOffsetIncrement.setType(type);
        incrByTypeOffsetIncrement.setOffset(offset);
        incrByTypeOffsetIncrement.setIncrement(increment);
        incrByTypeOffsetIncrement.setRawType(rawType);
        incrByTypeOffsetIncrement.setRawOffset(rawOffset);
        return idx;
    }

    private int parseSet(int i, Object[] params, SetTypeOffsetValue setTypeOffsetValue) {
        int idx = i;
        this.accept(CommandParsers.objToString(params[idx++]), "SET");
        String type = CommandParsers.objToString(params[idx]);
        byte[] rawType = CommandParsers.objToBytes(params[idx]);
        String offset = CommandParsers.objToString(params[++idx]);
        byte[] rawOffset = CommandParsers.objToBytes(params[idx]);
        int n = ++idx;
        ++idx;
        long value = new BigDecimal(CommandParsers.objToString(params[n])).longValueExact();
        setTypeOffsetValue.setType(type);
        setTypeOffsetValue.setOffset(offset);
        setTypeOffsetValue.setValue(value);
        setTypeOffsetValue.setRawType(rawType);
        setTypeOffsetValue.setRawOffset(rawOffset);
        return idx;
    }

    private int parseGet(int i, Object[] params, GetTypeOffset getTypeOffset) {
        int idx = i;
        this.accept(CommandParsers.objToString(params[idx++]), "GET");
        String type = CommandParsers.objToString(params[idx]);
        byte[] rawType = CommandParsers.objToBytes(params[idx]);
        String offset = CommandParsers.objToString(params[++idx]);
        byte[] rawOffset = CommandParsers.objToBytes(params[idx]);
        getTypeOffset.setType(type);
        getTypeOffset.setOffset(offset);
        getTypeOffset.setRawType(rawType);
        getTypeOffset.setRawOffset(rawOffset);
        return ++idx;
    }

    private void accept(String actual, String expect) {
        if (actual.equalsIgnoreCase(expect)) {
            return;
        }
        throw new AssertionError((Object)("expect " + expect + " but actual " + actual));
    }
}

