/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.impl.Limit;
import com.moilioncircle.redis.replicator.cmd.impl.OrderType;
import com.moilioncircle.redis.replicator.cmd.impl.SortCommand;
import com.moilioncircle.redis.replicator.cmd.parser.CommandParsers;
import java.math.BigDecimal;
import java.util.ArrayList;

public class SortParser
implements CommandParser<SortCommand> {
    @Override
    public SortCommand parse(Object[] command) {
        int idx = 1;
        SortCommand sort = new SortCommand();
        String key = CommandParsers.objToString(command[idx]);
        byte[] rawKey = CommandParsers.objToBytes(command[idx]);
        ++idx;
        sort.setKey(key);
        sort.setRawKey(rawKey);
        sort.setOrder(OrderType.NONE);
        ArrayList<String> getPatterns = new ArrayList<String>();
        ArrayList<byte[]> rawGetPatterns = new ArrayList<byte[]>();
        while (idx < command.length) {
            String param = CommandParsers.objToString(command[idx]);
            if ("ASC".equalsIgnoreCase(param)) {
                sort.setOrder(OrderType.ASC);
            } else if ("DESC".equalsIgnoreCase(param)) {
                sort.setOrder(OrderType.DESC);
            } else if ("ALPHA".equalsIgnoreCase(param)) {
                sort.setAlpha(true);
            } else if ("LIMIT".equalsIgnoreCase(param) && idx + 2 < command.length) {
                long offset = new BigDecimal(CommandParsers.objToString(command[++idx])).longValueExact();
                long count = new BigDecimal(CommandParsers.objToString(command[++idx])).longValueExact();
                sort.setLimit(new Limit(offset, count));
            } else if ("STORE".equalsIgnoreCase(param) && idx + 1 < command.length) {
                String destination = CommandParsers.objToString(command[++idx]);
                byte[] rawDestination = CommandParsers.objToBytes(command[idx]);
                sort.setDestination(destination);
                sort.setRawDestination(rawDestination);
            } else if ("BY".equalsIgnoreCase(param) && idx + 1 < command.length) {
                String byPattern = CommandParsers.objToString(command[++idx]);
                byte[] rawByPattern = CommandParsers.objToBytes(command[idx]);
                sort.setByPattern(byPattern);
                sort.setRawByPattern(rawByPattern);
            } else if ("GET".equalsIgnoreCase(param) && idx + 1 < command.length) {
                String getPattern = CommandParsers.objToString(command[++idx]);
                byte[] rawGetPattern = CommandParsers.objToBytes(command[idx]);
                getPatterns.add(getPattern);
                rawGetPatterns.add(rawGetPattern);
            }
            ++idx;
        }
        sort.setGetPatterns(getPatterns.toArray(new String[getPatterns.size()]));
        sort.setRawGetPatterns((byte[][])rawGetPatterns.toArray((T[])new byte[rawGetPatterns.size()][]));
        return sort;
    }
}

