/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator;

import com.moilioncircle.redis.replicator.FileType;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class RedisURI
implements Comparable<RedisURI>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private String string;
    private transient String host;
    private transient String path;
    private transient String query;
    private transient int port = -1;
    private transient String scheme;
    private transient String userInfo;
    private transient String fragment;
    private transient String authority;
    private transient FileType fileType;
    private transient URI uri;
    transient Map<String, String> parameters = new HashMap<String, String>();

    public RedisURI(String uri) throws URISyntaxException {
        this.parse(uri);
        this.string = this.uri.toString();
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getAuthority() {
        return this.authority;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public boolean equals(Object o) {
        return o instanceof RedisURI && this.uri.equals(((RedisURI)o).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    @Override
    public int compareTo(RedisURI that) {
        return this.uri.compareTo(that.uri);
    }

    public URL toURL() throws MalformedURLException {
        Objects.requireNonNull(this.getFileType());
        try {
            return new URI("file", this.uri.getRawAuthority(), this.uri.getRawPath(), this.uri.getRawQuery(), this.uri.getRawFragment()).toURL();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    public String toString() {
        return this.uri.toString();
    }

    public String toASCIIString() {
        return RedisURI.encode(this.uri.toString());
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        this.port = -1;
        is.defaultReadObject();
        try {
            this.parse(this.string);
        }
        catch (URISyntaxException x) {
            InvalidObjectException y = new InvalidObjectException("Invalid Redis URI");
            y.initCause(x);
            throw y;
        }
    }

    private void parse(String uri) throws URISyntaxException {
        String rawQuery;
        int idx;
        this.uri = new URI(uri);
        if (this.uri.getScheme() == null || !this.uri.getScheme().equalsIgnoreCase("redis")) {
            throw new IllegalArgumentException("scheme must be [redis].");
        }
        this.scheme = "redis";
        this.host = this.uri.getHost();
        this.path = this.uri.getPath();
        this.query = this.uri.getQuery();
        this.port = this.uri.getPort() == -1 ? 6379 : this.uri.getPort();
        this.userInfo = this.uri.getUserInfo();
        this.fragment = this.uri.getFragment();
        this.authority = this.uri.getAuthority();
        if (this.path != null && this.userInfo == null && (idx = this.path.lastIndexOf(46)) >= 0) {
            String type = this.path.substring(idx + 1);
            this.fileType = FileType.parse(type);
        }
        if ((rawQuery = this.uri.getRawQuery()) == null) {
            return;
        }
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        StringBuilder sb = key;
        block4: for (char c : rawQuery.toCharArray()) {
            switch (c) {
                case '&': 
                case ';': {
                    if (key.length() > 0 && value.length() > 0) {
                        this.parameters.put(RedisURI.decode(key.toString()), RedisURI.decode(value.toString()));
                    }
                    key.setLength(0);
                    value.setLength(0);
                    sb = key;
                    continue block4;
                }
                case '=': {
                    sb = value;
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (key.length() > 0 && value.length() > 0) {
            this.parameters.put(RedisURI.decode(key.toString()), RedisURI.decode(value.toString()));
        }
    }

    private static String decode(String s) {
        if (s == null) {
            return null;
        }
        int n = s.length();
        if (n == 0) {
            return s;
        }
        if (s.indexOf(37) < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(n);
        ByteBuffer bb = ByteBuffer.allocate(n);
        char c = s.charAt(0);
        int i = 0;
        while (i < n) {
            if (c != '%') {
                sb.append(c);
                if (++i >= n) break;
                c = s.charAt(i);
                continue;
            }
            bb.clear();
            do {
                bb.put(RedisURI.decode(s.charAt(++i), s.charAt(++i)));
            } while (++i < n && (c = s.charAt(i)) == '%');
            bb.flip();
            CharBuffer cb = StandardCharsets.UTF_8.decode(bb);
            sb.append(cb.toString());
        }
        return sb.toString();
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    private static byte decode(char c1, char c2) {
        return (byte)((RedisURI.decode(c1) & 0xF) << 4 | (RedisURI.decode(c2) & 0xF) << 0);
    }

    private static String encode(String s) {
        int n = s.length();
        if (n == 0) {
            return s;
        }
        int i = 0;
        while (s.charAt(i) < '\u0080') {
            if (++i < n) continue;
            return s;
        }
        String ns = Normalizer.normalize(s, Normalizer.Form.NFC);
        ByteBuffer bb = StandardCharsets.UTF_8.encode(CharBuffer.wrap(ns));
        StringBuilder sb = new StringBuilder();
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (b >= 128) {
                RedisURI.appendEscape(sb, (byte)b);
                continue;
            }
            sb.append((char)b);
        }
        return sb.toString();
    }

    private static void appendEscape(StringBuilder sb, byte b) {
        sb.append('%');
        sb.append(HEX_DIGITS[b >> 4 & 0xF]);
        sb.append(HEX_DIGITS[b >> 0 & 0xF]);
    }
}

