/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb;

import com.moilioncircle.redis.replicator.Constants;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.event.Event;
import com.moilioncircle.redis.replicator.io.ByteArrayInputStream;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.BaseRdbParser;
import com.moilioncircle.redis.replicator.rdb.RdbVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.AuxField;
import com.moilioncircle.redis.replicator.rdb.datatype.DB;
import com.moilioncircle.redis.replicator.rdb.datatype.ExpiredType;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueHash;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueList;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueModule;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueSet;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueString;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueZSet;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyValuePair;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.datatype.ZSetEntry;
import com.moilioncircle.redis.replicator.rdb.module.ModuleParser;
import com.moilioncircle.redis.replicator.util.ByteArray;
import com.moilioncircle.redis.replicator.util.ByteArrayMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultRdbVisitor
extends RdbVisitor {
    protected static final Log logger = LogFactory.getLog(DefaultRdbVisitor.class);
    protected final Replicator replicator;

    public DefaultRdbVisitor(Replicator replicator) {
        this.replicator = replicator;
    }

    @Override
    public String applyMagic(RedisInputStream in) throws IOException {
        String magicString = BaseRdbParser.StringHelper.str(in, 5);
        if (!magicString.equals("REDIS")) {
            throw new UnsupportedOperationException("can't read MAGIC STRING [REDIS] ,value:" + magicString);
        }
        return magicString;
    }

    @Override
    public int applyVersion(RedisInputStream in) throws IOException {
        int version = Integer.parseInt(BaseRdbParser.StringHelper.str(in, 4));
        if (version < 2 || version > 8) {
            throw new UnsupportedOperationException(String.valueOf("can't handle RDB format version " + version));
        }
        return version;
    }

    @Override
    public int applyType(RedisInputStream in) throws IOException {
        return in.read();
    }

    @Override
    public DB applySelectDB(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        long dbNumber = parser.rdbLoadLen().len;
        return new DB(dbNumber);
    }

    @Override
    public DB applyResizeDB(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        long dbsize = parser.rdbLoadLen().len;
        long expiresSize = parser.rdbLoadLen().len;
        if (db != null) {
            db.setDbsize(dbsize);
        }
        if (db != null) {
            db.setExpires(expiresSize);
        }
        return db;
    }

    @Override
    public long applyEof(RedisInputStream in, int version) throws IOException {
        if (version >= 5) {
            return in.readLong(8);
        }
        return 0L;
    }

    @Override
    public Event applyExpireTime(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        int expiredSec = parser.rdbLoadTime();
        int valueType = this.applyType(in);
        KeyValuePair<?> kv = this.rdbLoadObject(in, db, valueType, version);
        kv.setExpiredType(ExpiredType.SECOND);
        kv.setExpiredValue(Long.valueOf(expiredSec));
        return kv;
    }

    @Override
    public Event applyExpireTimeMs(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        long expiredMs = parser.rdbLoadMillisecondTime();
        int valueType = this.applyType(in);
        KeyValuePair<?> kv = this.rdbLoadObject(in, db, valueType, version);
        kv.setExpiredType(ExpiredType.MS);
        kv.setExpiredValue(expiredMs);
        return kv;
    }

    @Override
    public Event applyAux(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        String auxKey = new String(parser.rdbLoadEncodedStringObject().first(), StandardCharsets.UTF_8);
        String auxValue = new String(parser.rdbLoadEncodedStringObject().first(), StandardCharsets.UTF_8);
        if (!auxKey.startsWith("%")) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("RDB " + auxKey + ": " + auxValue));
            }
            if (auxKey.equals("repl-id")) {
                this.replicator.getConfiguration().setReplId(auxValue);
            }
            if (auxKey.equals("repl-offset")) {
                this.replicator.getConfiguration().setReplOffset(Long.parseLong(auxValue));
            }
            if (auxKey.equals("repl-stream-db")) {
                this.replicator.getConfiguration().setReplStreamDB(Integer.parseInt(auxValue));
            }
            return new AuxField(auxKey, auxValue);
        }
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("unrecognized RDB AUX field: " + auxKey + ", value: " + auxValue));
        }
        return null;
    }

    @Override
    public Event applyString(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueString o0 = new KeyStringValueString();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        byte[] val = parser.rdbLoadEncodedStringObject().first();
        o0.setValueRdbType(0);
        o0.setValue(new String(val, StandardCharsets.UTF_8));
        o0.setRawValue(val);
        o0.setDb(db);
        o0.setKey(new String(key, StandardCharsets.UTF_8));
        o0.setRawKey(key);
        return o0;
    }

    @Override
    public Event applyList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueList o1 = new KeyStringValueList();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        long len = parser.rdbLoadLen().len;
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<byte[]> rawList = new ArrayList<byte[]>();
        int i = 0;
        while ((long)i < len) {
            byte[] element = parser.rdbLoadEncodedStringObject().first();
            list.add(new String(element, StandardCharsets.UTF_8));
            rawList.add(element);
            ++i;
        }
        o1.setValueRdbType(1);
        o1.setValue(list);
        o1.setRawValue(rawList);
        o1.setDb(db);
        o1.setKey(new String(key, StandardCharsets.UTF_8));
        o1.setRawKey(key);
        return o1;
    }

    @Override
    public Event applySet(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueSet o2 = new KeyStringValueSet();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        long len = parser.rdbLoadLen().len;
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        LinkedHashSet<byte[]> rawSet = new LinkedHashSet<byte[]>();
        int i = 0;
        while ((long)i < len) {
            byte[] element = parser.rdbLoadEncodedStringObject().first();
            set.add(new String(element, StandardCharsets.UTF_8));
            rawSet.add(element);
            ++i;
        }
        o2.setValueRdbType(2);
        o2.setValue(set);
        o2.setRawValue(rawSet);
        o2.setDb(db);
        o2.setKey(new String(key, StandardCharsets.UTF_8));
        o2.setRawKey(key);
        return o2;
    }

    @Override
    public Event applyZSet(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueZSet o3 = new KeyStringValueZSet();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        LinkedHashSet<ZSetEntry> zset = new LinkedHashSet<ZSetEntry>();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            byte[] element = parser.rdbLoadEncodedStringObject().first();
            double score = parser.rdbLoadDoubleValue();
            zset.add(new ZSetEntry(new String(element, StandardCharsets.UTF_8), score, element));
        }
        o3.setValueRdbType(3);
        o3.setValue(zset);
        o3.setDb(db);
        o3.setKey(new String(key, StandardCharsets.UTF_8));
        o3.setRawKey(key);
        return o3;
    }

    @Override
    public Event applyZSet2(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueZSet o5 = new KeyStringValueZSet();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        LinkedHashSet<ZSetEntry> zset = new LinkedHashSet<ZSetEntry>();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            byte[] element = parser.rdbLoadEncodedStringObject().first();
            double score = parser.rdbLoadBinaryDoubleValue();
            zset.add(new ZSetEntry(new String(element, StandardCharsets.UTF_8), score, element));
        }
        o5.setValueRdbType(5);
        o5.setValue(zset);
        o5.setDb(db);
        o5.setKey(new String(key, StandardCharsets.UTF_8));
        o5.setRawKey(key);
        return o5;
    }

    @Override
    public Event applyHash(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueHash o4 = new KeyStringValueHash();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        ByteArrayMap<byte[]> rawMap = new ByteArrayMap<byte[]>();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            byte[] field = parser.rdbLoadEncodedStringObject().first();
            byte[] value = parser.rdbLoadEncodedStringObject().first();
            map.put(new String(field, StandardCharsets.UTF_8), new String(value, StandardCharsets.UTF_8));
            rawMap.put(field, value);
        }
        o4.setValueRdbType(4);
        o4.setValue(map);
        o4.setRawValue(rawMap);
        o4.setDb(db);
        o4.setKey(new String(key, StandardCharsets.UTF_8));
        o4.setRawKey(key);
        return o4;
    }

    @Override
    public Event applyHashZipMap(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueHash o9 = new KeyStringValueHash();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        ByteArray aux = parser.rdbLoadPlainStringObject();
        RedisInputStream stream = new RedisInputStream(new ByteArrayInputStream(aux));
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        ByteArrayMap<byte[]> rawMap = new ByteArrayMap<byte[]>();
        BaseRdbParser.LenHelper.zmlen(stream);
        while (true) {
            int zmEleLen;
            if ((zmEleLen = BaseRdbParser.LenHelper.zmElementLen(stream)) == 255) {
                o9.setValueRdbType(9);
                o9.setValue(map);
                o9.setRawValue(rawMap);
                o9.setDb(db);
                o9.setKey(new String(key, StandardCharsets.UTF_8));
                o9.setRawKey(key);
                return o9;
            }
            byte[] field = BaseRdbParser.StringHelper.bytes(stream, zmEleLen);
            zmEleLen = BaseRdbParser.LenHelper.zmElementLen(stream);
            if (zmEleLen == 255) {
                map.put(new String(field, StandardCharsets.UTF_8), null);
                rawMap.put(field, (byte[])null);
                o9.setValueRdbType(9);
                o9.setValue(map);
                o9.setRawValue(rawMap);
                o9.setDb(db);
                o9.setKey(new String(key, StandardCharsets.UTF_8));
                o9.setRawKey(key);
                return o9;
            }
            int free = BaseRdbParser.LenHelper.free(stream);
            byte[] value = BaseRdbParser.StringHelper.bytes(stream, zmEleLen);
            BaseRdbParser.StringHelper.skip(stream, free);
            map.put(new String(field, StandardCharsets.UTF_8), new String(value, StandardCharsets.UTF_8));
            rawMap.put(field, value);
        }
    }

    @Override
    public Event applyListZipList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueList o10 = new KeyStringValueList();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        ByteArray aux = parser.rdbLoadPlainStringObject();
        RedisInputStream stream = new RedisInputStream(new ByteArrayInputStream(aux));
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<byte[]> rawList = new ArrayList<byte[]>();
        BaseRdbParser.LenHelper.zlbytes(stream);
        BaseRdbParser.LenHelper.zltail(stream);
        int zllen = BaseRdbParser.LenHelper.zllen(stream);
        for (int i = 0; i < zllen; ++i) {
            byte[] e = BaseRdbParser.StringHelper.zipListEntry(stream);
            list.add(new String(e, StandardCharsets.UTF_8));
            rawList.add(e);
        }
        int zlend = BaseRdbParser.LenHelper.zlend(stream);
        if (zlend != 255) {
            throw new AssertionError((Object)("zlend expect 255 but " + zlend));
        }
        o10.setValueRdbType(10);
        o10.setValue(list);
        o10.setRawValue(rawList);
        o10.setDb(db);
        o10.setKey(new String(key, StandardCharsets.UTF_8));
        o10.setRawKey(key);
        return o10;
    }

    @Override
    public Event applySetIntSet(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueSet o11 = new KeyStringValueSet();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        ByteArray aux = parser.rdbLoadPlainStringObject();
        RedisInputStream stream = new RedisInputStream(new ByteArrayInputStream(aux));
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        LinkedHashSet<byte[]> rawSet = new LinkedHashSet<byte[]>();
        int encoding = BaseRdbParser.LenHelper.encoding(stream);
        long lenOfContent = BaseRdbParser.LenHelper.lenOfContent(stream);
        block5: for (long i = 0L; i < lenOfContent; ++i) {
            switch (encoding) {
                case 2: {
                    String element = String.valueOf(stream.readInt(2));
                    set.add(element);
                    rawSet.add(element.getBytes());
                    continue block5;
                }
                case 4: {
                    String element = String.valueOf(stream.readInt(4));
                    set.add(element);
                    rawSet.add(element.getBytes());
                    continue block5;
                }
                case 8: {
                    String element = String.valueOf(stream.readLong(8));
                    set.add(element);
                    rawSet.add(element.getBytes());
                    continue block5;
                }
                default: {
                    throw new AssertionError((Object)("expect encoding [2,4,8] but:" + encoding));
                }
            }
        }
        o11.setValueRdbType(11);
        o11.setValue(set);
        o11.setRawValue(rawSet);
        o11.setDb(db);
        o11.setKey(new String(key, StandardCharsets.UTF_8));
        o11.setRawKey(key);
        return o11;
    }

    @Override
    public Event applyZSetZipList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueZSet o12 = new KeyStringValueZSet();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        ByteArray aux = parser.rdbLoadPlainStringObject();
        RedisInputStream stream = new RedisInputStream(new ByteArrayInputStream(aux));
        LinkedHashSet<ZSetEntry> zset = new LinkedHashSet<ZSetEntry>();
        BaseRdbParser.LenHelper.zlbytes(stream);
        BaseRdbParser.LenHelper.zltail(stream);
        for (int zllen = BaseRdbParser.LenHelper.zllen(stream); zllen > 0; --zllen) {
            byte[] element = BaseRdbParser.StringHelper.zipListEntry(stream);
            --zllen;
            double score = Double.valueOf(new String(BaseRdbParser.StringHelper.zipListEntry(stream), StandardCharsets.UTF_8));
            zset.add(new ZSetEntry(new String(element, StandardCharsets.UTF_8), score, element));
        }
        int zlend = BaseRdbParser.LenHelper.zlend(stream);
        if (zlend != 255) {
            throw new AssertionError((Object)("zlend expect 255 but " + zlend));
        }
        o12.setValueRdbType(12);
        o12.setValue(zset);
        o12.setDb(db);
        o12.setKey(new String(key, StandardCharsets.UTF_8));
        o12.setRawKey(key);
        return o12;
    }

    @Override
    public Event applyHashZipList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueHash o13 = new KeyStringValueHash();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        ByteArray aux = parser.rdbLoadPlainStringObject();
        RedisInputStream stream = new RedisInputStream(new ByteArrayInputStream(aux));
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        ByteArrayMap<byte[]> rawMap = new ByteArrayMap<byte[]>();
        BaseRdbParser.LenHelper.zlbytes(stream);
        BaseRdbParser.LenHelper.zltail(stream);
        for (int zllen = BaseRdbParser.LenHelper.zllen(stream); zllen > 0; --zllen) {
            byte[] field = BaseRdbParser.StringHelper.zipListEntry(stream);
            --zllen;
            byte[] value = BaseRdbParser.StringHelper.zipListEntry(stream);
            map.put(new String(field, StandardCharsets.UTF_8), new String(value, StandardCharsets.UTF_8));
            rawMap.put(field, value);
        }
        int zlend = BaseRdbParser.LenHelper.zlend(stream);
        if (zlend != 255) {
            throw new AssertionError((Object)("zlend expect 255 but " + zlend));
        }
        o13.setValueRdbType(13);
        o13.setValue(map);
        o13.setRawValue(rawMap);
        o13.setDb(db);
        o13.setKey(new String(key, StandardCharsets.UTF_8));
        o13.setRawKey(key);
        return o13;
    }

    @Override
    public Event applyListQuickList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueList o14 = new KeyStringValueList();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        long len = parser.rdbLoadLen().len;
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<byte[]> rawList = new ArrayList<byte[]>();
        int i = 0;
        while ((long)i < len) {
            ByteArray element = parser.rdbGenericLoadStringObject(0);
            RedisInputStream stream = new RedisInputStream(new ByteArrayInputStream(element));
            BaseRdbParser.LenHelper.zlbytes(stream);
            BaseRdbParser.LenHelper.zltail(stream);
            int zllen = BaseRdbParser.LenHelper.zllen(stream);
            for (int j = 0; j < zllen; ++j) {
                byte[] e = BaseRdbParser.StringHelper.zipListEntry(stream);
                list.add(new String(e, StandardCharsets.UTF_8));
                rawList.add(e);
            }
            int zlend = BaseRdbParser.LenHelper.zlend(stream);
            if (zlend != 255) {
                throw new AssertionError((Object)("zlend expect 255 but " + zlend));
            }
            ++i;
        }
        o14.setValueRdbType(14);
        o14.setValue(list);
        o14.setRawValue(rawList);
        o14.setDb(db);
        o14.setKey(new String(key, StandardCharsets.UTF_8));
        o14.setRawKey(key);
        return o14;
    }

    @Override
    public Event applyModule(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueModule o6 = new KeyStringValueModule();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        char[] c = new char[9];
        long moduleid = parser.rdbLoadLen().len;
        for (int i = 0; i < c.length; ++i) {
            c[i] = Constants.MODULE_SET[(int)(moduleid >>> 10 + (c.length - 1 - i) * 6 & 0x3FL)];
        }
        String moduleName = new String(c);
        int moduleVersion = (int)(moduleid & 0x3FFL);
        ModuleParser<? extends Module> moduleParser = this.lookupModuleParser(moduleName, moduleVersion);
        if (moduleParser == null) {
            throw new NoSuchElementException("module[" + moduleName + "," + moduleVersion + "] not exist.");
        }
        o6.setValueRdbType(6);
        o6.setValue(moduleParser.parse(in, 1));
        o6.setDb(db);
        o6.setKey(new String(key, StandardCharsets.UTF_8));
        o6.setRawKey(key);
        return o6;
    }

    @Override
    public Event applyModule2(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueModule o7 = new KeyStringValueModule();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        char[] c = new char[9];
        long moduleid = parser.rdbLoadLen().len;
        for (int i = 0; i < c.length; ++i) {
            c[i] = Constants.MODULE_SET[(int)(moduleid >>> 10 + (c.length - 1 - i) * 6 & 0x3FL)];
        }
        String moduleName = new String(c);
        int moduleVersion = (int)(moduleid & 0x3FFL);
        ModuleParser<? extends Module> moduleParser = this.lookupModuleParser(moduleName, moduleVersion);
        if (moduleParser == null) {
            throw new NoSuchElementException("module[" + moduleName + "," + moduleVersion + "] not exist.");
        }
        o7.setValueRdbType(7);
        o7.setValue(moduleParser.parse(in, 2));
        o7.setDb(db);
        o7.setKey(new String(key, StandardCharsets.UTF_8));
        o7.setRawKey(key);
        long eof = parser.rdbLoadLen().len;
        if (eof != 0L) {
            throw new UnsupportedOperationException("The RDB file contains module data for the module '" + moduleName + "' that is not terminated by the proper module value EOF marker");
        }
        return o7;
    }

    protected ModuleParser<? extends Module> lookupModuleParser(String moduleName, int moduleVersion) {
        return this.replicator.getModuleParser(moduleName, moduleVersion);
    }

    protected KeyValuePair<?> rdbLoadObject(RedisInputStream in, DB db, int valueType, int version) throws IOException {
        switch (valueType) {
            case 0: {
                return (KeyValuePair)this.applyString(in, db, version);
            }
            case 1: {
                return (KeyValuePair)this.applyList(in, db, version);
            }
            case 2: {
                return (KeyValuePair)this.applySet(in, db, version);
            }
            case 3: {
                return (KeyValuePair)this.applyZSet(in, db, version);
            }
            case 5: {
                return (KeyValuePair)this.applyZSet2(in, db, version);
            }
            case 4: {
                return (KeyValuePair)this.applyHash(in, db, version);
            }
            case 9: {
                return (KeyValuePair)this.applyHashZipMap(in, db, version);
            }
            case 10: {
                return (KeyValuePair)this.applyListZipList(in, db, version);
            }
            case 11: {
                return (KeyValuePair)this.applySetIntSet(in, db, version);
            }
            case 12: {
                return (KeyValuePair)this.applyZSetZipList(in, db, version);
            }
            case 13: {
                return (KeyValuePair)this.applyHashZipList(in, db, version);
            }
            case 14: {
                return (KeyValuePair)this.applyListQuickList(in, db, version);
            }
            case 6: {
                return (KeyValuePair)this.applyModule(in, db, version);
            }
            case 7: {
                return (KeyValuePair)this.applyModule2(in, db, version);
            }
        }
        throw new AssertionError((Object)("unexpected value type:" + valueType));
    }
}

