/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.skip;

import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.BaseRdbParser;
import java.io.IOException;

public class SkipRdbParser {
    protected final RedisInputStream in;

    public SkipRdbParser(RedisInputStream in) {
        this.in = in;
    }

    public void rdbLoadTime() throws IOException {
        this.in.skip(4L);
    }

    public void rdbLoadMillisecondTime() throws IOException {
        this.in.skip(8L);
    }

    public BaseRdbParser.Len rdbLoadLen() throws IOException {
        return new BaseRdbParser(this.in).rdbLoadLen();
    }

    public void rdbLoadIntegerObject(int enctype) throws IOException {
        switch (enctype) {
            case 0: {
                this.in.skip(1L);
                break;
            }
            case 1: {
                this.in.skip(2L);
                break;
            }
            case 2: {
                this.in.skip(4L);
                break;
            }
        }
    }

    public void rdbLoadLzfStringObject() throws IOException {
        long clen = this.rdbLoadLen().len;
        this.rdbLoadLen();
        this.in.skip(clen);
    }

    public void rdbGenericLoadStringObject() throws IOException {
        BaseRdbParser.Len lenObj = this.rdbLoadLen();
        long len = (int)lenObj.len;
        boolean isencoded = lenObj.isencoded;
        if (isencoded) {
            switch ((int)len) {
                case 0: 
                case 1: 
                case 2: {
                    this.rdbLoadIntegerObject((int)len);
                    return;
                }
                case 3: {
                    this.rdbLoadLzfStringObject();
                    return;
                }
            }
            throw new AssertionError((Object)("unknown RdbParser encoding type:" + len));
        }
        this.in.skip(len);
    }

    public void rdbLoadPlainStringObject() throws IOException {
        this.rdbGenericLoadStringObject();
    }

    public void rdbLoadEncodedStringObject() throws IOException {
        this.rdbGenericLoadStringObject();
    }

    public void rdbLoadDoubleValue() throws IOException {
        int len = this.in.read();
        switch (len) {
            case 253: 
            case 254: 
            case 255: {
                return;
            }
        }
        this.in.skip(len);
    }

    public void rdbLoadBinaryDoubleValue() throws IOException {
        this.in.skip(8L);
    }
}

