/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.Limit;
import com.moilioncircle.redis.replicator.cmd.impl.OrderType;
import com.moilioncircle.redis.replicator.cmd.impl.SortCommand;
import com.moilioncircle.redis.replicator.util.Strings;
import java.util.ArrayList;

public class SortParser
implements CommandParser<SortCommand> {
    @Override
    public SortCommand parse(Object[] command) {
        int idx = 1;
        SortCommand sort = new SortCommand();
        String key = CommandParsers.toRune(command[idx]);
        byte[] rawKey = CommandParsers.toBytes(command[idx]);
        ++idx;
        sort.setKey(key);
        sort.setRawKey(rawKey);
        sort.setOrder(OrderType.NONE);
        ArrayList<String> getPatterns = new ArrayList<String>();
        ArrayList<byte[]> rawGetPatterns = new ArrayList<byte[]>();
        while (idx < command.length) {
            String param = CommandParsers.toRune(command[idx]);
            if (Strings.isEquals(param, "ASC")) {
                sort.setOrder(OrderType.ASC);
            } else if (Strings.isEquals(param, "DESC")) {
                sort.setOrder(OrderType.DESC);
            } else if (Strings.isEquals(param, "ALPHA")) {
                sort.setAlpha(true);
            } else if (Strings.isEquals(param, "LIMIT") && idx + 2 < command.length) {
                long offset = CommandParsers.toLong(command[++idx]);
                long count = CommandParsers.toLong(command[++idx]);
                sort.setLimit(new Limit(offset, count));
            } else if (Strings.isEquals(param, "STORE") && idx + 1 < command.length) {
                String destination = CommandParsers.toRune(command[++idx]);
                byte[] rawDestination = CommandParsers.toBytes(command[idx]);
                sort.setDestination(destination);
                sort.setRawDestination(rawDestination);
            } else if (Strings.isEquals(param, "BY") && idx + 1 < command.length) {
                String byPattern = CommandParsers.toRune(command[++idx]);
                byte[] rawByPattern = CommandParsers.toBytes(command[idx]);
                sort.setByPattern(byPattern);
                sort.setRawByPattern(rawByPattern);
            } else if (Strings.isEquals(param, "GET") && idx + 1 < command.length) {
                String getPattern = CommandParsers.toRune(command[++idx]);
                byte[] rawGetPattern = CommandParsers.toBytes(command[idx]);
                getPatterns.add(getPattern);
                rawGetPatterns.add(rawGetPattern);
            }
            ++idx;
        }
        sort.setGetPatterns(getPatterns.toArray(new String[getPatterns.size()]));
        sort.setRawGetPatterns((byte[][])rawGetPatterns.toArray((T[])new byte[rawGetPatterns.size()][]));
        return sort;
    }
}

