/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.MaxLen;
import com.moilioncircle.redis.replicator.cmd.impl.XAddCommand;
import com.moilioncircle.redis.replicator.util.ByteArrayMap;
import com.moilioncircle.redis.replicator.util.Strings;
import java.util.LinkedHashMap;
import java.util.Objects;

public class XAddParser
implements CommandParser<XAddCommand> {
    @Override
    public XAddCommand parse(Object[] command) {
        int idx = 1;
        String key = CommandParsers.toRune(command[idx]);
        byte[] rawKey = CommandParsers.toBytes(command[idx]);
        MaxLen maxLen = null;
        if (Strings.isEquals(CommandParsers.toRune(command[++idx]), "MAXLEN")) {
            boolean approximation = false;
            if (Objects.equals(CommandParsers.toRune(command[++idx]), "~")) {
                approximation = true;
                ++idx;
            }
            long count = CommandParsers.toLong(command[idx]);
            ++idx;
            maxLen = new MaxLen(approximation, count);
        }
        String id = CommandParsers.toRune(command[idx]);
        byte[] rawId = CommandParsers.toBytes(command[idx]);
        ++idx;
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        ByteArrayMap<byte[]> rawFields = new ByteArrayMap<byte[]>();
        while (idx < command.length) {
            String field = CommandParsers.toRune(command[idx]);
            byte[] rawField = CommandParsers.toBytes(command[idx]);
            String value = ++idx == command.length ? null : CommandParsers.toRune(command[idx]);
            byte[] rawValue = idx == command.length ? null : CommandParsers.toBytes(command[idx]);
            ++idx;
            fields.put(field, value);
            rawFields.put(rawField, rawValue);
        }
        return new XAddCommand(key, maxLen, id, fields, rawKey, rawId, rawFields);
    }
}

