/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.XClaimCommand;
import com.moilioncircle.redis.replicator.util.Strings;
import java.util.ArrayList;
import java.util.Objects;

public class XClaimParser
implements CommandParser<XClaimCommand> {
    @Override
    public XClaimCommand parse(Object[] command) {
        int idx = 1;
        String key = CommandParsers.toRune(command[idx]);
        byte[] rawKey = CommandParsers.toBytes(command[idx]);
        String group = CommandParsers.toRune(command[++idx]);
        byte[] rawGroup = CommandParsers.toBytes(command[idx]);
        String consumer = CommandParsers.toRune(command[++idx]);
        byte[] rawConsumer = CommandParsers.toBytes(command[idx]);
        int n = ++idx;
        ++idx;
        long minIdle = CommandParsers.toLong(command[n]);
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<byte[]> rawIds = new ArrayList<byte[]>();
        while (idx < command.length) {
            String id = CommandParsers.toRune(command[idx]);
            byte[] rawId = CommandParsers.toBytes(command[idx]);
            if (!this.validId(id)) break;
            ids.add(id);
            rawIds.add(rawId);
            ++idx;
        }
        Long idle = null;
        Long time = null;
        Long retryCount = null;
        boolean force = false;
        boolean justId = false;
        while (idx < command.length) {
            String next = CommandParsers.toRune(command[idx]);
            if (Strings.isEquals(next, "IDLE")) {
                idle = CommandParsers.toLong(command[++idx]);
                ++idx;
                continue;
            }
            if (Strings.isEquals(next, "TIME")) {
                time = CommandParsers.toLong(command[++idx]);
                ++idx;
                continue;
            }
            if (Strings.isEquals(next, "RETRYCOUNT")) {
                retryCount = CommandParsers.toLong(command[++idx]);
                ++idx;
                continue;
            }
            if (Strings.isEquals(next, "FORCE")) {
                ++idx;
                force = true;
                continue;
            }
            if (Strings.isEquals(next, "JUSTID")) {
                ++idx;
                justId = true;
                continue;
            }
            throw new UnsupportedOperationException(next);
        }
        return new XClaimCommand(key, group, consumer, minIdle, ids.toArray(new String[0]), idle, time, retryCount, force, justId, rawKey, rawGroup, rawConsumer, (byte[][])rawIds.toArray((T[])new byte[0][]));
    }

    private boolean validId(String id) {
        if (id == null) {
            return false;
        }
        if (Objects.equals(id, "+") || Objects.equals(id, "-")) {
            return true;
        }
        int idx = id.indexOf(45);
        try {
            Long.parseLong(id.substring(0, idx));
            Long.parseLong(id.substring(idx + 1, id.length()));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

