/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.XGroupCommand;
import com.moilioncircle.redis.replicator.cmd.impl.XGroupCreateCommand;
import com.moilioncircle.redis.replicator.cmd.impl.XGroupDelConsumerCommand;
import com.moilioncircle.redis.replicator.cmd.impl.XGroupDestroyCommand;
import com.moilioncircle.redis.replicator.cmd.impl.XGroupSetIdCommand;
import com.moilioncircle.redis.replicator.util.Strings;

public class XGroupParser
implements CommandParser<XGroupCommand> {
    @Override
    public XGroupCommand parse(Object[] command) {
        String next;
        int idx = 1;
        if (Strings.isEquals(next = CommandParsers.toRune(command[idx++]), "CREATE")) {
            String key = CommandParsers.toRune(command[idx]);
            byte[] rawKey = CommandParsers.toBytes(command[idx]);
            String group = CommandParsers.toRune(command[++idx]);
            byte[] rawGroup = CommandParsers.toBytes(command[idx]);
            String id = CommandParsers.toRune(command[++idx]);
            byte[] rawId = CommandParsers.toBytes(command[idx]);
            ++idx;
            return new XGroupCreateCommand(key, group, id, rawKey, rawGroup, rawId);
        }
        if (Strings.isEquals(next, "SETID")) {
            String key = CommandParsers.toRune(command[idx]);
            byte[] rawKey = CommandParsers.toBytes(command[idx]);
            String group = CommandParsers.toRune(command[++idx]);
            byte[] rawGroup = CommandParsers.toBytes(command[idx]);
            String id = CommandParsers.toRune(command[++idx]);
            byte[] rawId = CommandParsers.toBytes(command[idx]);
            ++idx;
            return new XGroupSetIdCommand(key, group, id, rawKey, rawGroup, rawId);
        }
        if (Strings.isEquals(next, "DESTROY")) {
            String key = CommandParsers.toRune(command[idx]);
            byte[] rawKey = CommandParsers.toBytes(command[idx]);
            String group = CommandParsers.toRune(command[++idx]);
            byte[] rawGroup = CommandParsers.toBytes(command[idx]);
            ++idx;
            return new XGroupDestroyCommand(key, group, rawKey, rawGroup);
        }
        if (Strings.isEquals(next, "DELCONSUMER")) {
            String key = CommandParsers.toRune(command[idx]);
            byte[] rawKey = CommandParsers.toBytes(command[idx]);
            String group = CommandParsers.toRune(command[++idx]);
            byte[] rawGroup = CommandParsers.toBytes(command[idx]);
            String consumer = CommandParsers.toRune(command[++idx]);
            byte[] rawConsumer = CommandParsers.toBytes(command[idx]);
            ++idx;
            return new XGroupDelConsumerCommand(key, group, consumer, rawKey, rawGroup, rawConsumer);
        }
        throw new UnsupportedOperationException(next);
    }
}

