/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.AggregateType;
import com.moilioncircle.redis.replicator.cmd.impl.ZInterStoreCommand;
import com.moilioncircle.redis.replicator.util.Strings;

public class ZInterStoreParser
implements CommandParser<ZInterStoreCommand> {
    @Override
    public ZInterStoreCommand parse(Object[] command) {
        int idx = 1;
        AggregateType aggregateType = null;
        String destination = CommandParsers.toRune(command[idx]);
        byte[] rawDestination = CommandParsers.toBytes(command[idx]);
        int n = ++idx;
        ++idx;
        int numkeys = CommandParsers.toInt(command[n]);
        String[] keys = new String[numkeys];
        byte[][] rawKeys = new byte[numkeys][];
        for (int i = 0; i < numkeys; ++i) {
            keys[i] = CommandParsers.toRune(command[idx]);
            rawKeys[i] = CommandParsers.toBytes(command[idx]);
            ++idx;
        }
        double[] weights = null;
        while (idx < command.length) {
            String param = CommandParsers.toRune(command[idx]);
            if (Strings.isEquals(param, "WEIGHTS")) {
                ++idx;
                weights = new double[numkeys];
                for (int i = 0; i < numkeys; ++i) {
                    weights[i] = CommandParsers.toDouble(command[idx++]);
                }
            }
            if (!Strings.isEquals(param, "AGGREGATE")) continue;
            int n2 = ++idx;
            ++idx;
            String next = CommandParsers.toRune(command[n2]);
            if (Strings.isEquals(next, "SUM")) {
                aggregateType = AggregateType.SUM;
                continue;
            }
            if (Strings.isEquals(next, "MIN")) {
                aggregateType = AggregateType.MIN;
                continue;
            }
            if (!Strings.isEquals(next, "MAX")) continue;
            aggregateType = AggregateType.MAX;
        }
        return new ZInterStoreCommand(destination, numkeys, keys, weights, aggregateType, rawDestination, rawKeys);
    }
}

