/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb;

import com.moilioncircle.redis.replicator.Constants;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.event.Event;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.BaseRdbParser;
import com.moilioncircle.redis.replicator.rdb.RdbVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.AuxField;
import com.moilioncircle.redis.replicator.rdb.datatype.DB;
import com.moilioncircle.redis.replicator.rdb.datatype.EvictType;
import com.moilioncircle.redis.replicator.rdb.datatype.ExpiredType;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueHash;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueList;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueModule;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueSet;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueStream;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueString;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueZSet;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyValuePair;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.datatype.Stream;
import com.moilioncircle.redis.replicator.rdb.datatype.ZSetEntry;
import com.moilioncircle.redis.replicator.rdb.module.ModuleParser;
import com.moilioncircle.redis.replicator.rdb.skip.SkipRdbParser;
import com.moilioncircle.redis.replicator.util.ByteArrayMap;
import com.moilioncircle.redis.replicator.util.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRdbVisitor
extends RdbVisitor {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultRdbVisitor.class);
    protected final Replicator replicator;

    public DefaultRdbVisitor(Replicator replicator) {
        this.replicator = replicator;
    }

    @Override
    public String applyMagic(RedisInputStream in) throws IOException {
        String magic = BaseRdbParser.StringHelper.str(in, 5);
        if (!magic.equals("REDIS")) {
            throw new UnsupportedOperationException("can't read MAGIC STRING [REDIS] ,value:" + magic);
        }
        return magic;
    }

    @Override
    public int applyVersion(RedisInputStream in) throws IOException {
        int version = Integer.parseInt(BaseRdbParser.StringHelper.str(in, 4));
        if (version < 2 || version > 9) {
            throw new UnsupportedOperationException(String.valueOf("can't handle RDB format version " + version));
        }
        return version;
    }

    @Override
    public int applyType(RedisInputStream in) throws IOException {
        return in.read();
    }

    @Override
    public DB applySelectDB(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        long dbNumber = parser.rdbLoadLen().len;
        return new DB(dbNumber);
    }

    @Override
    public DB applyResizeDB(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        long dbsize = parser.rdbLoadLen().len;
        long expiresSize = parser.rdbLoadLen().len;
        if (db != null) {
            db.setDbsize(dbsize);
        }
        if (db != null) {
            db.setExpires(expiresSize);
        }
        return db;
    }

    @Override
    public Event applyAux(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        String auxKey = Strings.toString(parser.rdbLoadEncodedStringObject().first());
        String auxValue = Strings.toString(parser.rdbLoadEncodedStringObject().first());
        if (!auxKey.startsWith("%")) {
            if (logger.isInfoEnabled()) {
                logger.info("RDB {}: {}", (Object)auxKey, (Object)auxValue);
            }
            if (auxKey.equals("repl-id")) {
                this.replicator.getConfiguration().setReplId(auxValue);
            }
            if (auxKey.equals("repl-offset")) {
                this.replicator.getConfiguration().setReplOffset(Long.parseLong(auxValue));
            }
            if (auxKey.equals("repl-stream-db")) {
                this.replicator.getConfiguration().setReplStreamDB(Integer.parseInt(auxValue));
            }
            return new AuxField(auxKey, auxValue);
        }
        if (logger.isWarnEnabled()) {
            logger.warn("unrecognized RDB AUX field: {}, value: {}", (Object)auxKey, (Object)auxValue);
        }
        return null;
    }

    @Override
    public Event applyModuleAux(RedisInputStream in, int version) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadLen();
        parser.rdbLoadCheckModuleValue();
        return null;
    }

    @Override
    public long applyEof(RedisInputStream in, int version) throws IOException {
        if (version >= 5) {
            return in.readLong(8);
        }
        return 0L;
    }

    @Override
    public Event applyExpireTime(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        int expiredSec = parser.rdbLoadTime();
        int type = this.applyType(in);
        KeyValuePair<Object> kv = type == 249 ? (KeyValuePair<?>)this.applyFreq(in, db, version) : (type == 248 ? (KeyValuePair)this.applyIdle(in, db, version) : this.rdbLoadObject(in, db, type, version));
        kv.setExpiredType(ExpiredType.SECOND);
        kv.setExpiredValue(Long.valueOf(expiredSec));
        return kv;
    }

    @Override
    public Event applyExpireTimeMs(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        long expiredMs = parser.rdbLoadMillisecondTime();
        int type = this.applyType(in);
        KeyValuePair<Object> kv = type == 249 ? (KeyValuePair<?>)this.applyFreq(in, db, version) : (type == 248 ? (KeyValuePair)this.applyIdle(in, db, version) : this.rdbLoadObject(in, db, type, version));
        kv.setExpiredType(ExpiredType.MS);
        kv.setExpiredValue(expiredMs);
        return kv;
    }

    @Override
    public Event applyFreq(RedisInputStream in, DB db, int version) throws IOException {
        long lfuFreq = in.read();
        int valueType = this.applyType(in);
        KeyValuePair<?> kv = this.rdbLoadObject(in, db, valueType, version);
        kv.setEvictType(EvictType.LFU);
        kv.setEvictValue(lfuFreq);
        return kv;
    }

    @Override
    public Event applyIdle(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        long lruIdle = parser.rdbLoadLen().len;
        int valueType = this.applyType(in);
        KeyValuePair<?> kv = this.rdbLoadObject(in, db, valueType, version);
        kv.setEvictType(EvictType.LRU);
        kv.setEvictValue(lruIdle);
        return kv;
    }

    @Override
    public Event applyString(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueString o0 = new KeyStringValueString();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        byte[] val = parser.rdbLoadEncodedStringObject().first();
        o0.setValueRdbType(0);
        o0.setValue(Strings.toString(val));
        o0.setRawValue(val);
        o0.setDb(db);
        o0.setKey(Strings.toString(key));
        o0.setRawKey(key);
        return o0;
    }

    @Override
    public Event applyList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueList o1 = new KeyStringValueList();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<byte[]> rawList = new ArrayList<byte[]>();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            byte[] element = parser.rdbLoadEncodedStringObject().first();
            list.add(Strings.toString(element));
            rawList.add(element);
        }
        o1.setValueRdbType(1);
        o1.setValue(list);
        o1.setRawValue(rawList);
        o1.setDb(db);
        o1.setKey(Strings.toString(key));
        o1.setRawKey(key);
        return o1;
    }

    @Override
    public Event applySet(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueSet o2 = new KeyStringValueSet();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        LinkedHashSet<byte[]> rawSet = new LinkedHashSet<byte[]>();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            byte[] element = parser.rdbLoadEncodedStringObject().first();
            set.add(Strings.toString(element));
            rawSet.add(element);
        }
        o2.setValueRdbType(2);
        o2.setValue(set);
        o2.setRawValue(rawSet);
        o2.setDb(db);
        o2.setKey(Strings.toString(key));
        o2.setRawKey(key);
        return o2;
    }

    @Override
    public Event applyZSet(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueZSet o3 = new KeyStringValueZSet();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        LinkedHashSet<ZSetEntry> zset = new LinkedHashSet<ZSetEntry>();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            byte[] element = parser.rdbLoadEncodedStringObject().first();
            double score = parser.rdbLoadDoubleValue();
            zset.add(new ZSetEntry(Strings.toString(element), score, element));
        }
        o3.setValueRdbType(3);
        o3.setValue(zset);
        o3.setDb(db);
        o3.setKey(Strings.toString(key));
        o3.setRawKey(key);
        return o3;
    }

    @Override
    public Event applyZSet2(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueZSet o5 = new KeyStringValueZSet();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        LinkedHashSet<ZSetEntry> zset = new LinkedHashSet<ZSetEntry>();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            byte[] element = parser.rdbLoadEncodedStringObject().first();
            double score = parser.rdbLoadBinaryDoubleValue();
            zset.add(new ZSetEntry(Strings.toString(element), score, element));
        }
        o5.setValueRdbType(5);
        o5.setValue(zset);
        o5.setDb(db);
        o5.setKey(Strings.toString(key));
        o5.setRawKey(key);
        return o5;
    }

    @Override
    public Event applyHash(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueHash o4 = new KeyStringValueHash();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        ByteArrayMap<byte[]> rawMap = new ByteArrayMap<byte[]>();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            byte[] field = parser.rdbLoadEncodedStringObject().first();
            byte[] value = parser.rdbLoadEncodedStringObject().first();
            map.put(Strings.toString(field), Strings.toString(value));
            rawMap.put(field, value);
        }
        o4.setValueRdbType(4);
        o4.setValue(map);
        o4.setRawValue(rawMap);
        o4.setDb(db);
        o4.setKey(Strings.toString(key));
        o4.setRawKey(key);
        return o4;
    }

    @Override
    public Event applyHashZipMap(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueHash o9 = new KeyStringValueHash();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        ByteArrayMap<byte[]> rawMap = new ByteArrayMap<byte[]>();
        BaseRdbParser.LenHelper.zmlen(stream);
        while (true) {
            int zmEleLen;
            if ((zmEleLen = BaseRdbParser.LenHelper.zmElementLen(stream)) == 255) {
                o9.setValueRdbType(9);
                o9.setValue(map);
                o9.setRawValue(rawMap);
                o9.setDb(db);
                o9.setKey(Strings.toString(key));
                o9.setRawKey(key);
                return o9;
            }
            byte[] field = BaseRdbParser.StringHelper.bytes(stream, zmEleLen);
            zmEleLen = BaseRdbParser.LenHelper.zmElementLen(stream);
            if (zmEleLen == 255) {
                map.put(Strings.toString(field), null);
                rawMap.put(field, (byte[])null);
                o9.setValueRdbType(9);
                o9.setValue(map);
                o9.setRawValue(rawMap);
                o9.setDb(db);
                o9.setKey(Strings.toString(key));
                o9.setRawKey(key);
                return o9;
            }
            int free = BaseRdbParser.LenHelper.free(stream);
            byte[] value = BaseRdbParser.StringHelper.bytes(stream, zmEleLen);
            BaseRdbParser.StringHelper.skip(stream, free);
            map.put(Strings.toString(field), Strings.toString(value));
            rawMap.put(field, value);
        }
    }

    @Override
    public Event applyListZipList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueList o10 = new KeyStringValueList();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<byte[]> rawList = new ArrayList<byte[]>();
        BaseRdbParser.LenHelper.zlbytes(stream);
        BaseRdbParser.LenHelper.zltail(stream);
        int zllen = BaseRdbParser.LenHelper.zllen(stream);
        for (int i = 0; i < zllen; ++i) {
            byte[] e = BaseRdbParser.StringHelper.zipListEntry(stream);
            list.add(Strings.toString(e));
            rawList.add(e);
        }
        int zlend = BaseRdbParser.LenHelper.zlend(stream);
        if (zlend != 255) {
            throw new AssertionError((Object)("zlend expect 255 but " + zlend));
        }
        o10.setValueRdbType(10);
        o10.setValue(list);
        o10.setRawValue(rawList);
        o10.setDb(db);
        o10.setKey(Strings.toString(key));
        o10.setRawKey(key);
        return o10;
    }

    @Override
    public Event applySetIntSet(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueSet o11 = new KeyStringValueSet();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        LinkedHashSet<byte[]> rawSet = new LinkedHashSet<byte[]>();
        int encoding = BaseRdbParser.LenHelper.encoding(stream);
        long lenOfContent = BaseRdbParser.LenHelper.lenOfContent(stream);
        block5: for (long i = 0L; i < lenOfContent; ++i) {
            switch (encoding) {
                case 2: {
                    String element = String.valueOf(stream.readInt(2));
                    set.add(element);
                    rawSet.add(element.getBytes());
                    continue block5;
                }
                case 4: {
                    String element = String.valueOf(stream.readInt(4));
                    set.add(element);
                    rawSet.add(element.getBytes());
                    continue block5;
                }
                case 8: {
                    String element = String.valueOf(stream.readLong(8));
                    set.add(element);
                    rawSet.add(element.getBytes());
                    continue block5;
                }
                default: {
                    throw new AssertionError((Object)("expect encoding [2,4,8] but:" + encoding));
                }
            }
        }
        o11.setValueRdbType(11);
        o11.setValue(set);
        o11.setRawValue(rawSet);
        o11.setDb(db);
        o11.setKey(Strings.toString(key));
        o11.setRawKey(key);
        return o11;
    }

    @Override
    public Event applyZSetZipList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueZSet o12 = new KeyStringValueZSet();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        LinkedHashSet<ZSetEntry> zset = new LinkedHashSet<ZSetEntry>();
        BaseRdbParser.LenHelper.zlbytes(stream);
        BaseRdbParser.LenHelper.zltail(stream);
        for (int zllen = BaseRdbParser.LenHelper.zllen(stream); zllen > 0; --zllen) {
            byte[] element = BaseRdbParser.StringHelper.zipListEntry(stream);
            --zllen;
            double score = Double.valueOf(Strings.toString(BaseRdbParser.StringHelper.zipListEntry(stream)));
            zset.add(new ZSetEntry(Strings.toString(element), score, element));
        }
        int zlend = BaseRdbParser.LenHelper.zlend(stream);
        if (zlend != 255) {
            throw new AssertionError((Object)("zlend expect 255 but " + zlend));
        }
        o12.setValueRdbType(12);
        o12.setValue(zset);
        o12.setDb(db);
        o12.setKey(Strings.toString(key));
        o12.setRawKey(key);
        return o12;
    }

    @Override
    public Event applyHashZipList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueHash o13 = new KeyStringValueHash();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        ByteArrayMap<byte[]> rawMap = new ByteArrayMap<byte[]>();
        BaseRdbParser.LenHelper.zlbytes(stream);
        BaseRdbParser.LenHelper.zltail(stream);
        for (int zllen = BaseRdbParser.LenHelper.zllen(stream); zllen > 0; --zllen) {
            byte[] field = BaseRdbParser.StringHelper.zipListEntry(stream);
            --zllen;
            byte[] value = BaseRdbParser.StringHelper.zipListEntry(stream);
            map.put(Strings.toString(field), Strings.toString(value));
            rawMap.put(field, value);
        }
        int zlend = BaseRdbParser.LenHelper.zlend(stream);
        if (zlend != 255) {
            throw new AssertionError((Object)("zlend expect 255 but " + zlend));
        }
        o13.setValueRdbType(13);
        o13.setValue(map);
        o13.setRawValue(rawMap);
        o13.setDb(db);
        o13.setKey(Strings.toString(key));
        o13.setRawKey(key);
        return o13;
    }

    @Override
    public Event applyListQuickList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueList o14 = new KeyStringValueList();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        long len = parser.rdbLoadLen().len;
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<byte[]> rawList = new ArrayList<byte[]>();
        for (long i = 0L; i < len; ++i) {
            RedisInputStream stream = new RedisInputStream(parser.rdbGenericLoadStringObject(0));
            BaseRdbParser.LenHelper.zlbytes(stream);
            BaseRdbParser.LenHelper.zltail(stream);
            int zllen = BaseRdbParser.LenHelper.zllen(stream);
            for (int j = 0; j < zllen; ++j) {
                byte[] e = BaseRdbParser.StringHelper.zipListEntry(stream);
                list.add(Strings.toString(e));
                rawList.add(e);
            }
            int zlend = BaseRdbParser.LenHelper.zlend(stream);
            if (zlend != 255) {
                throw new AssertionError((Object)("zlend expect 255 but " + zlend));
            }
        }
        o14.setValueRdbType(14);
        o14.setValue(list);
        o14.setRawValue(rawList);
        o14.setDb(db);
        o14.setKey(Strings.toString(key));
        o14.setRawKey(key);
        return o14;
    }

    @Override
    public Event applyModule(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueModule o6 = new KeyStringValueModule();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        char[] c = new char[9];
        long moduleid = parser.rdbLoadLen().len;
        for (int i = 0; i < c.length; ++i) {
            c[i] = Constants.MODULE_SET[(int)(moduleid >>> 10 + (c.length - 1 - i) * 6 & 0x3FL)];
        }
        String moduleName = new String(c);
        int moduleVersion = (int)(moduleid & 0x3FFL);
        ModuleParser<? extends Module> moduleParser = this.lookupModuleParser(moduleName, moduleVersion);
        if (moduleParser == null) {
            throw new NoSuchElementException("module parser[" + moduleName + ", " + moduleVersion + "] not register. rdb type: [RDB_TYPE_MODULE]");
        }
        o6.setValueRdbType(6);
        o6.setValue(moduleParser.parse(in, 1));
        o6.setDb(db);
        o6.setKey(Strings.toString(key));
        o6.setRawKey(key);
        return o6;
    }

    @Override
    public Event applyModule2(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueModule o7 = new KeyStringValueModule();
        byte[] rawKey = parser.rdbLoadEncodedStringObject().first();
        String key = Strings.toString(rawKey);
        char[] c = new char[9];
        long moduleid = parser.rdbLoadLen().len;
        for (int i = 0; i < c.length; ++i) {
            c[i] = Constants.MODULE_SET[(int)(moduleid >>> 10 + (c.length - 1 - i) * 6 & 0x3FL)];
        }
        String moduleName = new String(c);
        int moduleVersion = (int)(moduleid & 0x3FFL);
        ModuleParser<? extends Module> moduleParser = this.lookupModuleParser(moduleName, moduleVersion);
        Module module = null;
        if (moduleParser == null) {
            logger.warn("module parser[{}, {}] not register. rdb type: [RDB_TYPE_MODULE_2]. key: [{}]. module parse skipped.", new Object[]{moduleName, moduleVersion, key});
            SkipRdbParser skipRdbParser = new SkipRdbParser(in);
            skipRdbParser.rdbLoadCheckModuleValue();
        } else {
            module = moduleParser.parse(in, 2);
            long eof = parser.rdbLoadLen().len;
            if (eof != 0L) {
                throw new UnsupportedOperationException("The RDB file contains module data for the module '" + moduleName + "' that is not terminated by the proper module value EOF marker");
            }
        }
        o7.setValueRdbType(7);
        o7.setValue(module);
        o7.setDb(db);
        o7.setKey(Strings.toString(rawKey));
        o7.setRawKey(rawKey);
        return o7;
    }

    protected ModuleParser<? extends Module> lookupModuleParser(String moduleName, int moduleVersion) {
        return this.replicator.getModuleParser(moduleName, moduleVersion);
    }

    @Override
    public Event applyStreamListPacks(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueStream o15 = new KeyStringValueStream();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        Stream stream = new Stream();
        TreeMap<Stream.ID, Stream.Entry> entries = new TreeMap<Stream.ID, Stream.Entry>(Stream.ID.COMPARATOR);
        long listPacks = parser.rdbLoadLen().len;
        while (listPacks-- > 0L) {
            RedisInputStream rawId = new RedisInputStream(parser.rdbLoadPlainStringObject());
            Stream.ID baseId = new Stream.ID(rawId.readLong(8, false), rawId.readLong(8, false));
            RedisInputStream listPack = new RedisInputStream(parser.rdbLoadPlainStringObject());
            listPack.skip(4L);
            listPack.skip(2L);
            long count = Long.parseLong(Strings.toString(BaseRdbParser.StringHelper.listPackEntry(listPack)));
            long deleted = Long.parseLong(Strings.toString(BaseRdbParser.StringHelper.listPackEntry(listPack)));
            int numFields = Integer.parseInt(Strings.toString(BaseRdbParser.StringHelper.listPackEntry(listPack)));
            byte[][] tempFields = new byte[numFields][];
            for (int i = 0; i < numFields; ++i) {
                tempFields[i] = BaseRdbParser.StringHelper.listPackEntry(listPack);
            }
            BaseRdbParser.StringHelper.listPackEntry(listPack);
            long total = count + deleted;
            while (total-- > 0L) {
                int i;
                boolean delete;
                LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
                ByteArrayMap<byte[]> rawFields = new ByteArrayMap<byte[]>();
                int flag = Integer.parseInt(Strings.toString(BaseRdbParser.StringHelper.listPackEntry(listPack)));
                long ms = Long.parseLong(Strings.toString(BaseRdbParser.StringHelper.listPackEntry(listPack)));
                long seq = Long.parseLong(Strings.toString(BaseRdbParser.StringHelper.listPackEntry(listPack)));
                Stream.ID id = baseId.delta(ms, seq);
                boolean bl = delete = (flag & 1) != 0;
                if ((flag & 2) != 0) {
                    for (i = 0; i < numFields; ++i) {
                        byte[] rawValue = BaseRdbParser.StringHelper.listPackEntry(listPack);
                        String value = Strings.toString(rawValue);
                        byte[] rawField = tempFields[i];
                        String field = Strings.toString(rawField);
                        fields.put(field, value);
                        rawFields.put(rawField, rawValue);
                    }
                    entries.put(id, new Stream.Entry(id, delete, fields, rawFields));
                } else {
                    numFields = Integer.parseInt(Strings.toString(BaseRdbParser.StringHelper.listPackEntry(listPack)));
                    for (i = 0; i < numFields; ++i) {
                        byte[] rawField = BaseRdbParser.StringHelper.listPackEntry(listPack);
                        String field = Strings.toString(rawField);
                        byte[] rawValue = BaseRdbParser.StringHelper.listPackEntry(listPack);
                        String value = Strings.toString(rawValue);
                        fields.put(field, value);
                        rawFields.put(rawField, rawValue);
                    }
                    entries.put(id, new Stream.Entry(id, delete, fields, rawFields));
                }
                BaseRdbParser.StringHelper.listPackEntry(listPack);
            }
            int lpend = listPack.read();
            if (lpend != 255) {
                throw new AssertionError((Object)("listpack expect 255 but " + lpend));
            }
        }
        long length = parser.rdbLoadLen().len;
        Stream.ID lastId = new Stream.ID(parser.rdbLoadLen().len, parser.rdbLoadLen().len);
        ArrayList<Stream.Group> groups = new ArrayList<Stream.Group>();
        long groupCount = parser.rdbLoadLen().len;
        while (groupCount-- > 0L) {
            Stream.Group group = new Stream.Group();
            byte[] groupName = parser.rdbLoadPlainStringObject().first();
            Stream.ID groupLastId = new Stream.ID(parser.rdbLoadLen().len, parser.rdbLoadLen().len);
            TreeMap<Stream.ID, Stream.Nack> groupPendingEntries = new TreeMap<Stream.ID, Stream.Nack>(Stream.ID.COMPARATOR);
            long globalPel = parser.rdbLoadLen().len;
            while (globalPel-- > 0L) {
                Stream.ID rawId = new Stream.ID(in.readLong(8, false), in.readLong(8, false));
                long deliveryTime = parser.rdbLoadMillisecondTime();
                long deliveryCount = parser.rdbLoadLen().len;
                groupPendingEntries.put(rawId, new Stream.Nack(rawId, null, deliveryTime, deliveryCount));
            }
            ArrayList<Stream.Consumer> consumers = new ArrayList<Stream.Consumer>();
            long consumerCount = parser.rdbLoadLen().len;
            while (consumerCount-- > 0L) {
                Stream.Consumer consumer = new Stream.Consumer();
                byte[] consumerName = parser.rdbLoadPlainStringObject().first();
                long seenTime = parser.rdbLoadMillisecondTime();
                TreeMap<Stream.ID, Stream.Nack> consumerPendingEntries = new TreeMap<Stream.ID, Stream.Nack>(Stream.ID.COMPARATOR);
                long pel = parser.rdbLoadLen().len;
                while (pel-- > 0L) {
                    Stream.ID rawId = new Stream.ID(in.readLong(8, false), in.readLong(8, false));
                    Stream.Nack nack = (Stream.Nack)groupPendingEntries.get(rawId);
                    nack.setConsumer(consumer);
                    consumerPendingEntries.put(rawId, nack);
                }
                consumer.setName(Strings.toString(consumerName));
                consumer.setSeenTime(seenTime);
                consumer.setPendingEntries(consumerPendingEntries);
                consumer.setRawName(consumerName);
                consumers.add(consumer);
            }
            group.setName(Strings.toString(groupName));
            group.setLastId(groupLastId);
            group.setPendingEntries(groupPendingEntries);
            group.setConsumers(consumers);
            group.setRawName(groupName);
            groups.add(group);
        }
        stream.setLastId(lastId);
        stream.setEntries(entries);
        stream.setLength(length);
        stream.setGroups(groups);
        o15.setValueRdbType(15);
        o15.setDb(db);
        o15.setValue(stream);
        o15.setKey(Strings.toString(key));
        o15.setRawKey(key);
        return o15;
    }

    protected KeyValuePair<?> rdbLoadObject(RedisInputStream in, DB db, int valueType, int version) throws IOException {
        switch (valueType) {
            case 0: {
                return (KeyValuePair)this.applyString(in, db, version);
            }
            case 1: {
                return (KeyValuePair)this.applyList(in, db, version);
            }
            case 2: {
                return (KeyValuePair)this.applySet(in, db, version);
            }
            case 3: {
                return (KeyValuePair)this.applyZSet(in, db, version);
            }
            case 5: {
                return (KeyValuePair)this.applyZSet2(in, db, version);
            }
            case 4: {
                return (KeyValuePair)this.applyHash(in, db, version);
            }
            case 9: {
                return (KeyValuePair)this.applyHashZipMap(in, db, version);
            }
            case 10: {
                return (KeyValuePair)this.applyListZipList(in, db, version);
            }
            case 11: {
                return (KeyValuePair)this.applySetIntSet(in, db, version);
            }
            case 12: {
                return (KeyValuePair)this.applyZSetZipList(in, db, version);
            }
            case 13: {
                return (KeyValuePair)this.applyHashZipList(in, db, version);
            }
            case 14: {
                return (KeyValuePair)this.applyListQuickList(in, db, version);
            }
            case 6: {
                return (KeyValuePair)this.applyModule(in, db, version);
            }
            case 7: {
                return (KeyValuePair)this.applyModule2(in, db, version);
            }
            case 15: {
                return (KeyValuePair)this.applyStreamListPacks(in, db, version);
            }
        }
        throw new AssertionError((Object)("unexpected value type:" + valueType));
    }
}

