/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator;

import com.moilioncircle.redis.replicator.CloseListener;
import com.moilioncircle.redis.replicator.ExceptionListener;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.ReplicatorListener;
import com.moilioncircle.redis.replicator.event.Event;
import com.moilioncircle.redis.replicator.event.EventListener;
import com.moilioncircle.redis.replicator.io.RawByteListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AbstractReplicatorListener
implements ReplicatorListener {
    protected final List<CloseListener> closeListeners = new CopyOnWriteArrayList<CloseListener>();
    protected final List<EventListener> eventListeners = new CopyOnWriteArrayList<EventListener>();
    protected final List<RawByteListener> rawByteListeners = new CopyOnWriteArrayList<RawByteListener>();
    protected final List<ExceptionListener> exceptionListeners = new CopyOnWriteArrayList<ExceptionListener>();

    @Override
    public boolean addEventListener(EventListener listener) {
        return this.eventListeners.add(listener);
    }

    @Override
    public boolean removeEventListener(EventListener listener) {
        return this.eventListeners.remove(listener);
    }

    @Override
    public boolean addRawByteListener(RawByteListener listener) {
        return this.rawByteListeners.add(listener);
    }

    @Override
    public boolean removeRawByteListener(RawByteListener listener) {
        return this.rawByteListeners.remove(listener);
    }

    @Override
    public boolean addCloseListener(CloseListener listener) {
        return this.closeListeners.add(listener);
    }

    @Override
    public boolean removeCloseListener(CloseListener listener) {
        return this.closeListeners.remove(listener);
    }

    @Override
    public boolean addExceptionListener(ExceptionListener listener) {
        return this.exceptionListeners.add(listener);
    }

    @Override
    public boolean removeExceptionListener(ExceptionListener listener) {
        return this.exceptionListeners.remove(listener);
    }

    protected void doEventListener(Replicator replicator, Event event) {
        if (this.eventListeners.isEmpty()) {
            return;
        }
        for (EventListener listener : this.eventListeners) {
            listener.onEvent(replicator, event);
        }
    }

    protected void doCloseListener(Replicator replicator) {
        if (this.closeListeners.isEmpty()) {
            return;
        }
        for (CloseListener listener : this.closeListeners) {
            listener.handle(replicator);
        }
    }

    protected void doExceptionListener(Replicator replicator, Throwable throwable, Event event) {
        if (this.exceptionListeners.isEmpty()) {
            return;
        }
        for (ExceptionListener listener : this.exceptionListeners) {
            listener.handle(replicator, throwable, event);
        }
    }
}

