/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb;

import com.moilioncircle.redis.replicator.AbstractReplicator;
import com.moilioncircle.redis.replicator.Status;
import com.moilioncircle.redis.replicator.event.Event;
import com.moilioncircle.redis.replicator.event.PostRdbSyncEvent;
import com.moilioncircle.redis.replicator.event.PreRdbSyncEvent;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.RdbVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.ContextKeyValuePair;
import com.moilioncircle.redis.replicator.rdb.datatype.DB;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbParser {
    protected final RedisInputStream in;
    protected final RdbVisitor rdbVisitor;
    protected final AbstractReplicator replicator;
    protected static final Logger logger = LoggerFactory.getLogger(RdbParser.class);

    public RdbParser(RedisInputStream in, AbstractReplicator replicator) {
        this.in = in;
        this.replicator = replicator;
        this.rdbVisitor = this.replicator.getRdbVisitor();
    }

    public long parse() throws IOException {
        this.replicator.submitEvent(new PreRdbSyncEvent());
        this.rdbVisitor.applyMagic(this.in);
        int version = this.rdbVisitor.applyVersion(this.in);
        DB db = null;
        block26: while (this.replicator.getStatus() == Status.CONNECTED) {
            Event event = null;
            int type = this.rdbVisitor.applyType(this.in);
            ContextKeyValuePair kv = new ContextKeyValuePair();
            kv.setDb(db);
            switch (type) {
                case 253: {
                    event = this.rdbVisitor.applyExpireTime(this.in, version, kv);
                    break;
                }
                case 252: {
                    event = this.rdbVisitor.applyExpireTimeMs(this.in, version, kv);
                    break;
                }
                case 249: {
                    event = this.rdbVisitor.applyFreq(this.in, version, kv);
                    break;
                }
                case 248: {
                    event = this.rdbVisitor.applyIdle(this.in, version, kv);
                    break;
                }
                case 250: {
                    event = this.rdbVisitor.applyAux(this.in, version);
                    break;
                }
                case 247: {
                    event = this.rdbVisitor.applyModuleAux(this.in, version);
                    break;
                }
                case 251: {
                    this.rdbVisitor.applyResizeDB(this.in, version, kv);
                    break;
                }
                case 254: {
                    db = this.rdbVisitor.applySelectDB(this.in, version);
                    break;
                }
                case 255: {
                    long checksum = this.rdbVisitor.applyEof(this.in, version);
                    this.replicator.submitEvent(new PostRdbSyncEvent(checksum));
                    break block26;
                }
                case 0: {
                    event = this.rdbVisitor.applyString(this.in, version, kv);
                    break;
                }
                case 1: {
                    event = this.rdbVisitor.applyList(this.in, version, kv);
                    break;
                }
                case 2: {
                    event = this.rdbVisitor.applySet(this.in, version, kv);
                    break;
                }
                case 3: {
                    event = this.rdbVisitor.applyZSet(this.in, version, kv);
                    break;
                }
                case 5: {
                    event = this.rdbVisitor.applyZSet2(this.in, version, kv);
                    break;
                }
                case 4: {
                    event = this.rdbVisitor.applyHash(this.in, version, kv);
                    break;
                }
                case 9: {
                    event = this.rdbVisitor.applyHashZipMap(this.in, version, kv);
                    break;
                }
                case 10: {
                    event = this.rdbVisitor.applyListZipList(this.in, version, kv);
                    break;
                }
                case 11: {
                    event = this.rdbVisitor.applySetIntSet(this.in, version, kv);
                    break;
                }
                case 12: {
                    event = this.rdbVisitor.applyZSetZipList(this.in, version, kv);
                    break;
                }
                case 13: {
                    event = this.rdbVisitor.applyHashZipList(this.in, version, kv);
                    break;
                }
                case 14: {
                    event = this.rdbVisitor.applyListQuickList(this.in, version, kv);
                    break;
                }
                case 6: {
                    event = this.rdbVisitor.applyModule(this.in, version, kv);
                    break;
                }
                case 7: {
                    event = this.rdbVisitor.applyModule2(this.in, version, kv);
                    break;
                }
                case 15: {
                    event = this.rdbVisitor.applyStreamListPacks(this.in, version, kv);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected value type:" + type + ", check your ModuleParser or ValueIterableRdbVisitor."));
                }
            }
            if (event == null) continue;
            if (this.replicator.verbose() && logger.isDebugEnabled()) {
                logger.debug("{}", (Object)event);
            }
            this.replicator.submitEvent(event);
        }
        return this.in.total();
    }
}

