/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ByteArrayMap
implements Map<byte[], byte[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<Element, Element> map;

    public ByteArrayMap(Map<? extends byte[], ? extends byte[]> m) {
        this(true, m);
    }

    public ByteArrayMap(boolean ordered, Map<? extends byte[], ? extends byte[]> m) {
        this(ordered, m == null ? 0 : m.size(), 0.75f);
        this.putAll(m);
    }

    public ByteArrayMap() {
        this(true);
    }

    public ByteArrayMap(boolean ordered) {
        this(ordered, 16);
    }

    public ByteArrayMap(boolean ordered, int initialCapacity) {
        this(ordered, initialCapacity, 0.75f);
    }

    public ByteArrayMap(boolean ordered, int initialCapacity, float loadFactor) {
        this.map = ordered ? new LinkedHashMap<Element, Element>(initialCapacity, loadFactor) : new HashMap<Element, Element>(initialCapacity, loadFactor);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key != null && !(key instanceof byte[])) {
            return false;
        }
        return this.map.containsKey(new Element((byte[])key));
    }

    @Override
    public boolean containsValue(Object value) {
        if (value != null && !(value instanceof byte[])) {
            return false;
        }
        return this.map.containsValue(new Element((byte[])value));
    }

    @Override
    public byte[] get(Object key) {
        if (key != null && !(key instanceof byte[])) {
            return null;
        }
        return this.map.get((Object)new Element((byte[])((byte[])key))).bytes;
    }

    @Override
    public byte[] put(byte[] key, byte[] value) {
        Element element = this.map.put(new Element(key), new Element(value));
        return element != null ? element.bytes : null;
    }

    @Override
    public void putAll(Map<? extends byte[], ? extends byte[]> m) {
        if (m == null) {
            return;
        }
        for (Map.Entry<? extends byte[], ? extends byte[]> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public byte[] remove(Object key) {
        if (key != null && !(key instanceof byte[])) {
            return null;
        }
        return this.map.remove((Object)new Element((byte[])((byte[])key))).bytes;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<byte[]> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<byte[]> values() {
        return new Values();
    }

    @Override
    public Set<Map.Entry<byte[], byte[]>> entrySet() {
        return new EntrySet();
    }

    public static final class Node
    implements Map.Entry<byte[], byte[]>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private byte[] value;
        private final byte[] key;

        private Node(byte[] key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public byte[] getKey() {
            return this.key;
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public byte[] setValue(byte[] value) {
            byte[] oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return Arrays.equals(this.value, node.value) && Arrays.equals(this.key, node.key);
        }

        @Override
        public int hashCode() {
            int result = Arrays.hashCode(this.value);
            result = 31 * result + Arrays.hashCode(this.key);
            return result;
        }
    }

    private final class EntryIterator
    implements Iterator<Map.Entry<byte[], byte[]>> {
        private final Iterator<Map.Entry<Element, Element>> iterator;

        private EntryIterator() {
            this.iterator = ByteArrayMap.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<byte[], byte[]> next() {
            Map.Entry<Element, Element> v = this.iterator.next();
            return new Node(v.getKey().bytes, v.getValue().bytes);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private final class ValueIterator
    implements Iterator<byte[]> {
        private final Iterator<Element> iterator;

        private ValueIterator() {
            this.iterator = ByteArrayMap.this.map.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public byte[] next() {
            return this.iterator.next().bytes;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private final class KeyIterator
    implements Iterator<byte[]> {
        private final Iterator<Element> iterator;

        private KeyIterator() {
            this.iterator = ByteArrayMap.this.map.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public byte[] next() {
            return this.iterator.next().bytes;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private final class Values
    extends AbstractCollection<byte[]> {
        private Values() {
        }

        @Override
        public final int size() {
            return ByteArrayMap.this.size();
        }

        @Override
        public final void clear() {
            ByteArrayMap.this.clear();
        }

        @Override
        public final Iterator<byte[]> iterator() {
            return new ValueIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return ByteArrayMap.this.containsValue(o);
        }
    }

    private final class KeySet
    extends AbstractSet<byte[]> {
        private KeySet() {
        }

        @Override
        public final int size() {
            return ByteArrayMap.this.size();
        }

        @Override
        public final void clear() {
            ByteArrayMap.this.clear();
        }

        @Override
        public final Iterator<byte[]> iterator() {
            return new KeyIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return ByteArrayMap.this.containsKey(o);
        }

        @Override
        public final boolean remove(Object key) {
            return ByteArrayMap.this.remove(key) != null;
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<byte[], byte[]>> {
        private EntrySet() {
        }

        @Override
        public final int size() {
            return ByteArrayMap.this.size();
        }

        @Override
        public final void clear() {
            ByteArrayMap.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<byte[], byte[]>> iterator() {
            return new EntryIterator();
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            if (k != null && !(k instanceof byte[])) {
                return false;
            }
            if (v != null && !(v instanceof byte[])) {
                return false;
            }
            byte[] key = (byte[])k;
            byte[] value = (byte[])v;
            if (!ByteArrayMap.this.containsKey(key)) {
                return false;
            }
            byte[] val = ByteArrayMap.this.get(key);
            return Arrays.equals(val, value);
        }

        @Override
        public final boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            if (k != null && !(k instanceof byte[])) {
                return false;
            }
            if (v != null && !(v instanceof byte[])) {
                return false;
            }
            byte[] key = (byte[])k;
            byte[] value = (byte[])v;
            if (!ByteArrayMap.this.containsKey(key)) {
                return false;
            }
            byte[] val = ByteArrayMap.this.get(key);
            if (Arrays.equals(val, value)) {
                return ByteArrayMap.this.remove(key) != null;
            }
            return false;
        }
    }

    public static final class Element
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final byte[] bytes;

        Element(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Element key = (Element)o;
            return Arrays.equals(this.bytes, key.bytes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }
    }
}

