package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.Objects;
import java.util.ArrayList;
import java.io.IOException;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.V2ConversationMessageTypingEventForWorkflowTopicConversationContentAttachment;
import com.mypurecloud.sdk.v2.model.V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateParameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

import java.io.Serializable;
/**
 * V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader
 */

public class V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader  implements Serializable {
  

  private static class TypeEnumDeserializer extends StdDeserializer<TypeEnum> {
    public TypeEnumDeserializer() {
      super(TypeEnumDeserializer.class);
    }

    @Override
    public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt)
            throws IOException {
      JsonNode node = jsonParser.getCodec().readTree(jsonParser);
      return TypeEnum.fromString(node.toString().replace("\"", ""));
    }
  }
  /**
   * Gets or Sets type
   */
 @JsonDeserialize(using = TypeEnumDeserializer.class)
  public enum TypeEnum {
    OUTDATEDSDKVERSION("OutdatedSdkVersion"),
    TEXT("Text"),
    MEDIA("Media");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonCreator
    public static TypeEnum fromString(String key) {
      if (key == null) return null;

      for (TypeEnum value : TypeEnum.values()) {
        if (key.equalsIgnoreCase(value.toString())) {
          return value;
        }
      }

      return TypeEnum.values()[0];
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }
  }
  private TypeEnum type = null;
  private String text = null;
  private V2ConversationMessageTypingEventForWorkflowTopicConversationContentAttachment media = null;
  private List<V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateParameter> parameters = new ArrayList<V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateParameter>();

  
  /**
   **/
  public V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader type(TypeEnum type) {
    this.type = type;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("type")
  public TypeEnum getType() {
    return type;
  }
  public void setType(TypeEnum type) {
    this.type = type;
  }


  /**
   **/
  public V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader text(String text) {
    this.text = text;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("text")
  public String getText() {
    return text;
  }
  public void setText(String text) {
    this.text = text;
  }


  /**
   **/
  public V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader media(V2ConversationMessageTypingEventForWorkflowTopicConversationContentAttachment media) {
    this.media = media;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("media")
  public V2ConversationMessageTypingEventForWorkflowTopicConversationContentAttachment getMedia() {
    return media;
  }
  public void setMedia(V2ConversationMessageTypingEventForWorkflowTopicConversationContentAttachment media) {
    this.media = media;
  }


  /**
   **/
  public V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader parameters(List<V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateParameter> parameters) {
    this.parameters = parameters;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("parameters")
  public List<V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateParameter> getParameters() {
    return parameters;
  }
  public void setParameters(List<V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateParameter> parameters) {
    this.parameters = parameters;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader v2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader = (V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader) o;

    return Objects.equals(this.type, v2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader.type) &&
            Objects.equals(this.text, v2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader.text) &&
            Objects.equals(this.media, v2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader.media) &&
            Objects.equals(this.parameters, v2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader.parameters);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, text, media, parameters);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V2ConversationMessageTypingEventForWorkflowTopicConversationNotificationTemplateHeader {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    media: ").append(toIndentedString(media)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

