/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.AdditionalMessage;
import java.util.HashMap;
import java.util.Map;

public class PostConversationsMessageCommunicationMessagesRequest {
    private String conversationId;
    private String communicationId;
    private AdditionalMessage body;
    private Boolean useNormalizedMessage;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PostConversationsMessageCommunicationMessagesRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getCommunicationId() {
        return this.communicationId;
    }

    public void setCommunicationId(String communicationId) {
        this.communicationId = communicationId;
    }

    public PostConversationsMessageCommunicationMessagesRequest withCommunicationId(String communicationId) {
        this.setCommunicationId(communicationId);
        return this;
    }

    public AdditionalMessage getBody() {
        return this.body;
    }

    public void setBody(AdditionalMessage body) {
        this.body = body;
    }

    public PostConversationsMessageCommunicationMessagesRequest withBody(AdditionalMessage body) {
        this.setBody(body);
        return this;
    }

    public Boolean getUseNormalizedMessage() {
        return this.useNormalizedMessage;
    }

    public void setUseNormalizedMessage(Boolean useNormalizedMessage) {
        this.useNormalizedMessage = useNormalizedMessage;
    }

    public PostConversationsMessageCommunicationMessagesRequest withUseNormalizedMessage(Boolean useNormalizedMessage) {
        this.setUseNormalizedMessage(useNormalizedMessage);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostConversationsMessageCommunicationMessagesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<AdditionalMessage> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationsMessageCommunicationMessagesRequest.");
        }
        if (this.communicationId == null) {
            throw new IllegalStateException("Missing the required parameter 'communicationId' when building request for PostConversationsMessageCommunicationMessagesRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationsMessageCommunicationMessagesRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/conversations/messages/{conversationId}/communications/{communicationId}/messages").withPathParameter("conversationId", this.conversationId).withPathParameter("communicationId", this.communicationId).withQueryParameters("useNormalizedMessage", "", this.useNormalizedMessage).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String communicationId, AdditionalMessage body) {
        return new Builder().withRequiredParams(conversationId, communicationId, body);
    }

    public static class Builder {
        private final PostConversationsMessageCommunicationMessagesRequest request = new PostConversationsMessageCommunicationMessagesRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withCommunicationId(String communicationId) {
            this.request.setCommunicationId(communicationId);
            return this;
        }

        public Builder withBody(AdditionalMessage body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withUseNormalizedMessage(Boolean useNormalizedMessage) {
            this.request.setUseNormalizedMessage(useNormalizedMessage);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String communicationId, AdditionalMessage body) {
            this.request.setConversationId(conversationId);
            this.request.setCommunicationId(communicationId);
            this.request.setBody(body);
            return this;
        }

        public PostConversationsMessageCommunicationMessagesRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationsMessageCommunicationMessagesRequest.");
            }
            if (this.request.communicationId == null) {
                throw new IllegalStateException("Missing the required parameter 'communicationId' when building request for PostConversationsMessageCommunicationMessagesRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationsMessageCommunicationMessagesRequest.");
            }
            return this.request;
        }
    }
}

