/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.NuanceApplication;
import com.mypurecloud.sdk.v2.model.NuanceBotCredentials;
import com.mypurecloud.sdk.v2.model.NuanceBotTransferNode;
import com.mypurecloud.sdk.v2.model.NuanceBotVariable;
import com.mypurecloud.sdk.v2.model.NuanceChannel;
import com.mypurecloud.sdk.v2.model.NuanceEnvironment;
import com.mypurecloud.sdk.v2.model.NuanceGeography;
import com.mypurecloud.sdk.v2.model.NuanceOrganization;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Model for a Nuance bot")
public class NuanceBot
implements Serializable {
    private String id = null;
    private String name = null;
    private String integrationId = null;
    private NuanceOrganization nuanceOrganization = null;
    private NuanceApplication application = null;
    private NuanceEnvironment nuanceEnvironment = null;
    private NuanceGeography geography = null;
    private List<NuanceBotCredentials> credentials = new ArrayList<NuanceBotCredentials>();
    private List<NuanceBotVariable> variables = new ArrayList<NuanceBotVariable>();
    private List<NuanceBotTransferNode> transferNodes = new ArrayList<NuanceBotTransferNode>();
    private List<String> locales = new ArrayList<String>();
    private List<NuanceChannel> channels = new ArrayList<NuanceChannel>();
    private String selfUri = null;

    public NuanceBot id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Nuance bot Id")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public NuanceBot name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Nuance bot name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NuanceBot integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Integration Id for this bot")
    @JsonProperty(value="integrationId")
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public NuanceBot nuanceOrganization(NuanceOrganization nuanceOrganization) {
        this.nuanceOrganization = nuanceOrganization;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Nuance Organization for this bot")
    @JsonProperty(value="nuanceOrganization")
    public NuanceOrganization getNuanceOrganization() {
        return this.nuanceOrganization;
    }

    public void setNuanceOrganization(NuanceOrganization nuanceOrganization) {
        this.nuanceOrganization = nuanceOrganization;
    }

    public NuanceBot application(NuanceApplication application) {
        this.application = application;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Application for this bot")
    @JsonProperty(value="application")
    public NuanceApplication getApplication() {
        return this.application;
    }

    public void setApplication(NuanceApplication application) {
        this.application = application;
    }

    public NuanceBot nuanceEnvironment(NuanceEnvironment nuanceEnvironment) {
        this.nuanceEnvironment = nuanceEnvironment;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The environment of the Nuance bot")
    @JsonProperty(value="nuanceEnvironment")
    public NuanceEnvironment getNuanceEnvironment() {
        return this.nuanceEnvironment;
    }

    public void setNuanceEnvironment(NuanceEnvironment nuanceEnvironment) {
        this.nuanceEnvironment = nuanceEnvironment;
    }

    public NuanceBot geography(NuanceGeography geography) {
        this.geography = geography;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Geography of the Nuance bot")
    @JsonProperty(value="geography")
    public NuanceGeography getGeography() {
        return this.geography;
    }

    public void setGeography(NuanceGeography geography) {
        this.geography = geography;
    }

    public NuanceBot credentials(List<NuanceBotCredentials> credentials) {
        this.credentials = credentials;
        return this;
    }

    @ApiModelProperty(example="null", value="client ID/Secret objects for the credentials that execute this Nuance bot")
    @JsonProperty(value="credentials")
    public List<NuanceBotCredentials> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(List<NuanceBotCredentials> credentials) {
        this.credentials = credentials;
    }

    public NuanceBot variables(List<NuanceBotVariable> variables) {
        this.variables = variables;
        return this;
    }

    @ApiModelProperty(example="null", value="List of available variables in this Nuance bot.  When querying, use the 'expand=variables' query param to populate this value")
    @JsonProperty(value="variables")
    public List<NuanceBotVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<NuanceBotVariable> variables) {
        this.variables = variables;
    }

    public NuanceBot transferNodes(List<NuanceBotTransferNode> transferNodes) {
        this.transferNodes = transferNodes;
        return this;
    }

    @ApiModelProperty(example="null", value="List of transferNodes in this Nuance bot.  When querying, use the 'expand=transferNodes' query param to populate this value")
    @JsonProperty(value="transferNodes")
    public List<NuanceBotTransferNode> getTransferNodes() {
        return this.transferNodes;
    }

    public void setTransferNodes(List<NuanceBotTransferNode> transferNodes) {
        this.transferNodes = transferNodes;
    }

    public NuanceBot locales(List<String> locales) {
        this.locales = locales;
        return this;
    }

    @ApiModelProperty(example="null", value="List of locales associated with this Nuance bot.  Generally in the ISO format such as 'en-US'")
    @JsonProperty(value="locales")
    public List<String> getLocales() {
        return this.locales;
    }

    public void setLocales(List<String> locales) {
        this.locales = locales;
    }

    public NuanceBot channels(List<NuanceChannel> channels) {
        this.channels = channels;
        return this;
    }

    @ApiModelProperty(example="null", value="List of channels associated with this Nuance bot.")
    @JsonProperty(value="channels")
    public List<NuanceChannel> getChannels() {
        return this.channels;
    }

    public void setChannels(List<NuanceChannel> channels) {
        this.channels = channels;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NuanceBot nuanceBot = (NuanceBot)o;
        return Objects.equals(this.id, nuanceBot.id) && Objects.equals(this.name, nuanceBot.name) && Objects.equals(this.integrationId, nuanceBot.integrationId) && Objects.equals(this.nuanceOrganization, nuanceBot.nuanceOrganization) && Objects.equals(this.application, nuanceBot.application) && Objects.equals(this.nuanceEnvironment, nuanceBot.nuanceEnvironment) && Objects.equals(this.geography, nuanceBot.geography) && Objects.equals(this.credentials, nuanceBot.credentials) && Objects.equals(this.variables, nuanceBot.variables) && Objects.equals(this.transferNodes, nuanceBot.transferNodes) && Objects.equals(this.locales, nuanceBot.locales) && Objects.equals(this.channels, nuanceBot.channels) && Objects.equals(this.selfUri, nuanceBot.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.integrationId, this.nuanceOrganization, this.application, this.nuanceEnvironment, this.geography, this.credentials, this.variables, this.transferNodes, this.locales, this.channels, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NuanceBot {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    nuanceOrganization: ").append(this.toIndentedString(this.nuanceOrganization)).append("\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("    nuanceEnvironment: ").append(this.toIndentedString(this.nuanceEnvironment)).append("\n");
        sb.append("    geography: ").append(this.toIndentedString(this.geography)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    transferNodes: ").append(this.toIndentedString(this.transferNodes)).append("\n");
        sb.append("    locales: ").append(this.toIndentedString(this.locales)).append("\n");
        sb.append("    channels: ").append(this.toIndentedString(this.channels)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

